model Ex12_6
OpenIPSL.Electrical.Machines.PSAT.Order2 order21(D = 0, M = 8, Sn = 100, Vn = 480, ra = 0.001, x1d = x1) annotation(
    Placement(visible = true, transformation(origin = {-56, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = x2) annotation(
    Placement(visible = true, transformation(origin = {4, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus1(V_0 = v0) annotation(
    Placement(visible = true, transformation(origin = {72, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  inner OpenIPSL.Electrical.SystemBase SysData annotation(
    Placement(visible = true, transformation(origin = {-59, 70}, extent = {{-23, -20}, {23, 20}}, rotation = 0)));
  constant Real pi = 2 * Modelica.Math.asin(1.0);// 3.14159265358979 in radian;  
  parameter Real R2D = 180 / pi"Radian to degree conversion";
  parameter Real D2R = pi / 180"Degree to radian conversion"; 
  parameter Real v0(unit = "pu") = 1"voltage of infinite bus";
  parameter Real vt(unit = "pu") = 1.20"terminal voltage of generator";
  parameter Real x1(unit = "pu") = 0.5"equivalent reactance of generator";
  parameter Complex X1=Complex(0,x1)"reactance of generator in complex form";
  parameter Real x2(unit = "pu") = 1"reactance of powerline";
  parameter Complex X2=Complex(0,x2)"reactance of powerline in complex form";
  parameter Real theta(unit = "rad")=acos(0.5/1.8)"voltage angle of generator";
  parameter Real theta1(unit = "degree")=theta*R2D"voltage angle of generator";
  parameter Complex Vt=Complex(vt * cos(theta), vt * sin(theta))"terminal voltage of generator in complex form";
  parameter Complex I=(Vt-v0)/X2"current in infinite bus";
  parameter Complex E=Vt+(X1*I)"internal machine voltage";
  parameter Real E_abs=(E.re ^ 2 + E.im ^ 2) ^ 0.5"absolute value of internal machine voltage";
  parameter Real E_arg(unit = "degree") = atan(E.im / E.re) * R2D"angle of internal machine voltage"; 
  parameter Real E_arg1(unit = "degree") = E_arg+180"angle of internal machine voltage"; 
  parameter Real P(unit = "pu") = E_abs * v0 / (x1 + x2)"steady state power limit";
   //The answers may slightly vary due to rounding off values.   

equation
  connect(order21.pm0, order21.pm) annotation(
    Line(points = {{-64, -10}, {-64, -10}, {-64, -18}, {-76, -18}, {-76, -6}, {-68, -6}, {-68, -4}}, color = {0, 0, 127}));
  connect(order21.vf0, order21.vf) annotation(
    Line(points = {{-64, 12}, {-64, 12}, {-64, 18}, {-76, 18}, {-76, 6}, {-68, 6}, {-68, 6}}, color = {0, 0, 127}));
  connect(order21.p, pwLine1.p) annotation(
    Line(points = {{-46, 0}, {-5, 0}}, color = {0, 0, 255}));
  connect(pwLine1.n, infiniteBus1.p) annotation(
    Line(points = {{13, 0}, {82, 0}}, color = {0, 0, 255}));

end Ex12_6;
