model Ex12_9
  parameter Modelica.SIunits.Frequency f = 50 "frequency of generator";
  parameter Real Pmax1(unit = "pu") = 2.0 "power before fault";
  parameter Real Pmax2(unit = "pu") = 0.5 "power during fault";
  parameter Real Pmax3(unit = "pu") = 1.5 "power after fault";
  parameter Real Pm(unit = "pu") = 1 "initial loading";
  parameter Real del0(unit = "rad") = asin(Pm / Pmax1)"prefault operating power angle";
  constant Real pi = 2 * Modelica.Math.asin(1.0);// 3.14159265358979 in radian;  
  parameter Real delmax(unit = "rad") = pi - asin(Pm / Pmax3)"maximum permissible angle";
  parameter Real cos_del_cr = ((Pm * (delmax - del0)) - (Pmax2 * cos(del0)) + (Pmax3 * cos(delmax))) / (Pmax3 - Pmax2)"value of cosine of critical clearing angle";
  parameter Real delcr(unit = "degree") = 180 / pi * acos(cos_del_cr) "critical clearing angle";
  //The answers may slightly vary due to rounding off values.   

end Ex12_9;
