model Ex14_3
parameter Modelica.SIunits.Voltage Vli = 325000 "ac line voltage";
  constant Real pi = 2 * Modelica.Math.asin(1.0)"this pi is considered as radian";
  parameter Modelica.SIunits.Reactance Xci = 100 "commutation reactance";
  parameter Modelica.SIunits.Voltage Vdi = 245000 "voltage at dc side";
  parameter Modelica.SIunits.Current Idi = 950 "current at dc side";
  parameter Modelica.SIunits.Resistance Rc = 3 / pi * Xci "commutation resistance";
  parameter Modelica.SIunits.Voltage Vd0 = 3 * 2 ^ 0.5 / pi * Vli"avg direct voltage for the inverter";
 // parameter Real A = ((Vdi + Rc * Idi) / Vd0);
  parameter Real gamma(unit = "degree") = 180 / pi * acos(((Vdi + Rc * Idi) / Vd0)) "extinction angle";
  parameter Real gamma1(unit = "rad") = pi / 180 * gamma"extinction angle";
  parameter Real B = 2 * Vdi / Vd0 - cos(gamma1) "cos(gamma+meu)";
  parameter Real C(unit = "degree") = 180 / pi * acos(B) "value of (gamma+meu)";
  parameter Real Meu(unit = "degree") = C - gamma "overlap angle";
//The answers may slightly vary due to rounding off values.
end Ex14_3;
