model Ex16_1
  parameter Real V(unit = "pu") = 1 "bus voltage";
  parameter Real Ksh = 0.8 "shunt compensation";
  parameter Real Qnom(unit = "pu") = 1 "nominal reactive power";
  parameter Real Qload(unit = "pu") = Qnom * V ^ 2 "load reactive power";
  parameter Real Qcomp(unit = "pu") = -Ksh * V ^ 2 "compensation reactive power,here (-ve) sign denotes inductive reactive power injection";
  parameter Real Qnet(unit = "pu") = Qload + Qcomp "net reactive power";
  parameter Real powersensitivity(unit = "pu") = 2 * V - 2 * V * Ksh"reactive power sensitivity at the bus wrt change in the voltage";
end Ex16_1;
