model Ex2_6
parameter Modelica.SIunits.Frequency f=50"line frequency";
parameter Modelica.SIunits.Distance D=3"distance between the conductors";
//Applying Pythagorous geometric formula in Fig-2.14 we get D1 and D2 as follows
parameter Modelica.SIunits.Distance D1=5.21^0.5"distance between power line1 and telephone line 1";
parameter Modelica.SIunits.Distance D2=7.61^0.5"distance between power line1 and telephone line 2";
parameter Modelica.SIunits.Current I=100"Current in power line";
parameter Complex w=Complex(0,-314)"a constant complex value";
parameter Real lambda_t1(final quantity="MagneticFluxlinkage", final unit="Wb-T/m")=2e-7*I*log(D2/D1)"flux linkages of conductor 1";
parameter Real lambda_t2(final quantity="MagneticFluxlinkage", final unit="Wb-T/m")=2e-7*I*log(D1/D2)"flux linkages of conductor 2";
parameter Real lambda_t(final quantity="MagneticFluxlinkage", final unit="Wb-T/m")=lambda_t1-lambda_t2"total flux linkages of telephone circuit";
parameter Real Mpt(final quantity="Inductance",final unit="mH/km")=0.921*log10(D2/D1)"mutual inductance";
parameter Modelica.SIunits.ComplexVoltage Vt=w*Mpt*1e-3*I"voltage induced in telephone circuit/km";
parameter Modelica.SIunits.Voltage Vt_abs=(Vt.re^2 + Vt.im^2)^0.5"absolute value of voltage induced in telephone circuit/km";
//The answer may slightly vary due to rounding off values.

end Ex2_6;
