model Ex5_2
parameter Real V_ss(final quantity="ElectricPotential", final unit="kV")=6"base voltage of substation";
parameter Real base_MVA(final quantity="Power", final unit="MVA")=5"base power of substation";
parameter Real base_kv_low(final quantity="ElectricPotential", final unit="kV")=6.6"base voltage on low voltage side of a transformer";
parameter Real base_kv_high(final quantity="ElectricPotential", final unit="kV")=33"base voltage on high voltage side of a transformer";
parameter Modelica.SIunits.Resistance r_c=8"resistance of cable/phase";
parameter Modelica.SIunits.Resistance x_c=2.5"reactance of cable/phase";
parameter Modelica.SIunits.Resistance r_d=0.06"resistance of delta connected winding of another transformer";
parameter Modelica.SIunits.Resistance x_d=0.36"reactance of delta connected winding of another transformer";
parameter Modelica.SIunits.Resistance r_s=0.5"resistance of star connected winding of another transformer";
parameter Modelica.SIunits.Resistance x_s=3.75"reactance of star connected winding of another transformer";
parameter Real load_MVA(final quantity="Power", final unit="MVA")=1"load power";
parameter Real sinfi=0.527"recative power factor";
parameter Real cosfi=0.85"real power factor";
parameter Modelica.SIunits.ComplexImpedance z_c=Complex(r_c,x_c)"cable impedance/phase";
parameter Complex Z_c1=(z_c*base_MVA)/(base_kv_high^2)"cable impedance in pu";
parameter Modelica.SIunits.ComplexImpedance z_s=(1/3)*Complex(r_d,x_d)"equivalent star impedance/phase of low voltage side of the transformer ";
parameter Modelica.SIunits.ComplexImpedance z_st=Complex(r_s,x_s)"star impedance";
parameter Complex Z_T=((z_s*base_MVA)/(base_kv_low^2))+((z_st*base_MVA)/(base_kv_high^2))"per unit transformer impedance";
parameter Complex Z_tsi=Z_c1+(2*Z_T)"total series impedance in pu";
parameter Real load_voltage(unit="pu")=V_ss/base_kv_low"load voltage";
parameter Real load_current(unit="pu")=load_MVA/load_voltage"load current";
parameter Real Vs(unit="pu")=load_voltage+(load_current*((Z_tsi.re*cosfi)+(Z_tsi.im*sinfi)))"line to line voltage";
parameter Real vs_ll(final quantity="ElectricPotential", final unit="kV")=Vs*base_kv_low"line to line bus voltage at the power station end";
//The answers may slightly vary due to rounding off values.
end Ex5_2;
