model Ex5_7
  constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979  in radian;
  parameter Real R2D = 180 / pi"Radian to degree conversion";
  parameter Real D2R = pi / 180"Degree to radian conversion";
  parameter Real load_v(final quantity="ElectricPotential", final unit="kV")=220"receiving end voltage";
  parameter Real Length(final quantity="Length", final unit="km")=400"lenght of transmission line";
  parameter Modelica.SIunits.Frequency f=50"line freqency";
  parameter Modelica.SIunits.Resistance r=0.125"line resistance/km";
  parameter Modelica.SIunits.Reactance x=0.4"line reactance/km";
  parameter Modelica.SIunits.Resistance  y=2.8*1e-6"line admittance/km";
  parameter Real l(final quantity="Length", final unit="km")=200"distance from the receiving end";
  parameter Modelica.SIunits.ComplexImpedance y1=Complex(0,y)"line admittance in complex form/km";
  parameter Modelica.SIunits.ComplexImpedance Z=Complex(r,x)"line impedance in complex form/km";
  parameter Modelica.SIunits.Impedance Z_abs = (Z.re ^ 2 + Z.im ^ 2) ^ 0.5"absolute value of  line impedance/km";
  parameter Real Z_arg(unit="degree") = atan(Z.im / Z.re) * R2D "angle of line impedance/km";
  parameter Real Y1=y*Z_abs"product of line admittance/km and impedance/km";
  parameter Complex Y2=Complex((Y1*cos((90+Z_arg)*D2R)),(Y1*sin((90+Z_arg)*D2R)))"product of line admittance/km and impedance/km";
  parameter Complex Y3=Y2^0.5"square root of product of line admittance/km and impedance/km";
  parameter Real Y3_abs = (Y3.re ^ 2 + Y3.im ^ 2) ^ 0.5"absolute value of square root of product of  line admittance/km and impedance/km";
  parameter Real Y3_arg(unit="degree") = atan(Y3.im / Y3.re) * R2D "angle of square root of product of line admittance/km and impedance/km";
  parameter Real a=Y3.re"value of alfa";
  parameter Real B=Y3.im"value of beta";
  parameter Complex B1=Complex(0,B)"value of beta in complex form";  
  //case a
  parameter Real Vi(final quantity="ElectricPotential", final unit="kV")=load_v/(2*(3^0.5))"incident voltage at receiving end";
  parameter Complex Vi_1=Complex(Vi,0)"incident voltage at receiving end in complex form in kV";
  parameter Complex Vre=Vi_1"reflected voltage at receiving end in kV";
  //case b
  parameter Complex Vi1=Complex((Vi*exp(a*l)*cos(B1.im*l)),(Vi*exp(a*l)*sin(B1.im*l)))"incident voltage at 200 km from receiving end in kV";
  parameter Real Vi1_abs(final quantity="ElectricPotential", final unit="kV") = (Vi1.re ^ 2 + Vi1.im ^ 2) ^ 0.5"absolute value of incident voltage at 200 km from receiving end";
  parameter Real Vi1_arg(unit="degree") = atan(Vi1.im / Vi1.re) * R2D "angle of incident voltage at 200 km from receiving end";
  parameter Complex Vre1=Complex((Vi*exp(-a*l)*cos(-B1.im*l)),(Vi*exp(-a*l)*sin(-B1.im*l)))"reflected voltage at 200 km from receiving end in kV";
  parameter Real Vre1_abs(final quantity="ElectricPotential", final unit="kV") = (Vre1.re ^ 2 + Vre1.im ^ 2) ^ 0.5"absolute value of reflected voltage at 200 km from receiving end";
  parameter Real Vre1_arg(unit="degree") = atan(Vre1.im / Vre1.re) * R2D "angle of reflected voltage at 200 km from receiving end";
  //case c
  parameter Complex V_total=Vi1+Vre1"resultant voltage at 200 km from receiving end in kV";
  parameter Real V_total_abs(final quantity="ElectricPotential", final unit="kV") = (V_total.re ^ 2 + V_total.im ^ 2) ^ 0.5"absolute value of resultant voltage at 200 km from receiving end";
  parameter Real V_total_arg(unit="degree") = atan(V_total.im / V_total.re) * R2D "angle of resultant voltage at 200 km from receiving end";
  parameter Real V(final quantity="ElectricPotential", final unit="kV")=V_total_abs*(3^0.5)"resultant  line-to-line voltage at 200 km";
 //The answers may slightly vary due to rounding off values. 
end Ex5_7;
