model Ex5_9
constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979 in radian;
parameter Real R2D = 180 / pi"Radian to degree conversion";
parameter Real D2R = pi / 180"Degree to radian conversion";
//case a
parameter Real mod_Vs(final quantity="ElectricPotential", final unit="kV")=275"sending end voltage of transmission line"; 
parameter Real mod_Vr(final quantity="ElectricPotential", final unit="kV")=275"receiving end voltage of transmission line";
parameter Complex A=Complex((0.85*cos(5*D2R)),(0.85*sin(5*D2R)))"line constant";
parameter Real A_abs = (A.re ^ 2 + A.im ^ 2) ^ 0.5"absolute value of A";
parameter Real A_arg(unit="degree") = atan(A.im / A.re) * R2D "angle of A";
parameter Complex B=Complex((200*cos(75*D2R)),(200*sin(75*D2R)))"line constant";
parameter Real B_abs = (B.re ^ 2 + B.im ^ 2) ^ 0.5"absolute value of B";
parameter Real B_arg(unit="degree") = atan(B.im / B.re) * R2D "angle of B";
parameter Real alfa(unit="degree")=A_arg"value of angle alfa";
parameter Real beta(unit="degree")=B_arg"value of angle beta";
parameter Real Qr(final quantity="Power", final unit="MW")=0"reactive power at receiving end";
parameter Real delta(unit="degree")=beta-asin((B_abs/(mod_Vs*mod_Vr))*(Qr+(A_abs/B_abs)*(mod_Vr^2)*sin((beta-alfa)*D2R)))*R2D"torque angle";
parameter Real Pr(final quantity="Power", final unit="MW")=((mod_Vs*mod_Vr)/B_abs)*cos((beta-delta)*D2R)-(A_abs/B_abs)*(mod_Vs^2)*cos((beta-alfa)*D2R)"real power at unity power factor at receiving end";
//case b
parameter Real PD(final quantity="Power", final unit="MW")=150"real power demanded by load at UPF";
parameter Real PR(final quantity="Power", final unit="MW")=PD"power demanded by load at UPF at receiving end";
parameter Real QD(final quantity="Power", final unit="MW")=0"reactive power demanded by load at UPF";
parameter Real delta1(unit="degree")=beta-acos((PD+(A_abs/B_abs)*(mod_Vs^2)*cos((beta-alfa)*D2R))*(B_abs/(mod_Vs*mod_Vr)))*R2D"torque angle";
parameter Real Q_rb(final quantity="Power", final unit="MVAR")=((mod_Vs*mod_Vr)/B_abs)*sin((beta-delta1)*D2R)-(A_abs/B_abs)*(mod_Vs^2)*sin((beta-alfa)*D2R)"reactive power at receiving end";
parameter Real Qc(final quantity="Power", final unit="MVAR")=-Q_rb"required compensation equipment power";
//case c
parameter Real mod_Vsc(final quantity="ElectricPotential", final unit="kV")=275"sending end voltage of transmission line";
//using Sridhar Acharya formula we can solve V-r as follows
parameter Real a=((A_abs/B_abs)*cos((beta-alfa)*D2R))^2+((mod_Vs/B_abs)*(A_abs/mod_Vsc)*sin((beta-alfa)*D2R))^2;
parameter Real b=(2*PR*((A_abs/B_abs)*cos((beta-alfa)*D2R)))-(mod_Vs/B_abs)^2;
parameter Real c=PR^2;
parameter Real V_r(final quantity="ElectricPotential", final unit="kV")=((-b+((b^2)-4*a*c)^0.5)/(2*a))^0.5"receiving end voltage if the compensation equipment is not installed";
//The answers may slightly vary due to rounding off values.
end Ex5_9;
