model Ex6_1
OpenIPSL.Electrical.Machines.PSAT.Order2 order21 annotation(
    Placement(visible = true, transformation(origin = {-76, 74}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order22 annotation(
    Placement(visible = true, transformation(origin = {72, 74}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order23 annotation(
    Placement(visible = true, transformation(origin = {-76, -80}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order24 annotation(
    Placement(visible = true, transformation(origin = {72, -78}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  OpenIPSL.Electrical.Buses.Bus bus1 annotation(
    Placement(visible = true, transformation(origin = {-76, 32}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus2(displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {72, 32}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus3 annotation(
    Placement(visible = true, transformation(origin = {-76, -20}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus4 annotation(
    Placement(visible = true, transformation(origin = {72, -22}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1 annotation(
    Placement(visible = true, transformation(origin = {-2, 42}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2 annotation(
    Placement(visible = true, transformation(origin = {-2, -30}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3 annotation(
    Placement(visible = true, transformation(origin = {0, 4}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine4 annotation(
    Placement(visible = true, transformation(origin = {72, -2}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine5 annotation(
    Placement(visible = true, transformation(origin = {-76, 0}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant1 annotation(
    Placement(visible = true, transformation(origin = {-83, 51}, extent = {{5, 5}, {-5, -5}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant2 annotation(
    Placement(visible = true, transformation(origin = {79, 49}, extent = {{5, 5}, {-5, -5}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant3 annotation(
    Placement(visible = true, transformation(origin = {-111, -59}, extent = {{-5, -5}, {5, 5}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant4 annotation(
    Placement(visible = true, transformation(origin = {115, -57}, extent = {{-5, -5}, {5, 5}}, rotation = 0)));
  parameter Real y10 "line admittance";
  parameter Real y20 "line admittance";
  parameter Real y30 "line admittance";
  parameter Real y40 "line admittance";
  parameter Real y12 "line admittance";
  parameter Real y13 "line admittance";
  parameter Real y23 "line admittance";
  parameter Real y24 "line admittance";
  parameter Real y34 "line admittance";
  parameter Real V1 "voltage of bus1";
  parameter Real V2 "voltage of bus2";
  parameter Real V3 "voltage of bus3";
  parameter Real V4 "voltage of bus4";
  //Applying KCL at nodes we have
  parameter Real I1 = y10 * V1 + y12 * (V1 - V2) + y13 * (V1 - V3)"current flows to bus1";
  parameter Real I2 = y20 * V2 + y12 * (V1 - V2) + y23 * (V1 - V3) + y24 * (V2 - V4)"current flows to bus2";
  parameter Real I3 = y30 * V3 + y13 * (V1 - V2) + y23 * (V1 - V3) + y34 * (V3 - V4)"current flows to bus3";
  parameter Real I4 = y40 * V4 + y24 * (V1 - V2) + y34 * (V1 - V3)"current flows to bus4";
  //Elements of Y_bus are
  parameter Real Y11 = y10 + y12 + y13"diagonal elements of Y_bus, they are self admittance";
  parameter Real Y12 = -y12"off-diagonal elements of y_bus, they are transfer admittance";
  parameter Real Y13 = -y13"off-diagonal elements of y_bus, they are transfer admittance";
  parameter Real Y14 = 0"off-diagonal elements of y_bus, they are transfer admittance";
  parameter Real Y21 = Y12"off-diagonal elements of y_bus, they are transfer admittance";
  parameter Real Y22 = y20 + y12 + y23 + y24"diagonal elements of Y_bus, they are self admittance";
  parameter Real Y23 = -y23"off-diagonal elements of y_bus, they are transfer admittance";
  parameter Real Y24 = -y24"off-diagonal elements of y_bus, they are transfer admittance";
  parameter Real Y31 = y13"off-diagonal elements of y_bus, they are transfer admittance";
  parameter Real Y32 = Y23"off-diagonal elements of y_bus, they are transfer admittance";
  parameter Real Y33 = y30 + y13 + y23 + y34"diagonal elements of Y_bus, they are self admittance";
  parameter Real Y34 = -y34"off-diagonal elements of y_bus, they are transfer admittance";
  parameter Real Y41 = Y14"off-diagonal elements of y_bus, they are transfer admittance";
  parameter Real Y42 = Y24"off-diagonal elements of y_bus, they are transfer admittance";
  parameter Real Y43 = Y34"off-diagonal elements of y_bus, they are transfer admittance";
  parameter Real Y44 = y40 + y24 + y34"diagonal elements of Y_bus, they are self admittance";
  parameter Real[4, 1] I_bus = {{I1}, {I2}, {I3}, {I4}}"bus currents in matrix form";
  parameter Real[4, 1] V_bus = {{V1}, {V2}, {V3}, {V4}}"bus voltages in matrix form";
  parameter Real[4, 4] Y_bus = {{Y11, Y12, Y13, Y14}, {Y21, Y22, Y23, Y24}, {Y31, Y32, Y33, Y34}, {Y41, Y42, Y43, Y44}}"bus admittances in matrix form";
  //THEREFORE WE CAN WRITE THE ABOVE EQUATIONS IN A MATRIX FORM AS FOLLOWS
  //parameter Real [4,1]I_bus=[4,4]Y_bus*[4,1]V_bus;
  inner OpenIPSL.Electrical.SystemBase SysData annotation(
    Placement(visible = true, transformation(origin = {-169, 77}, extent = {{-17, -17}, {17, 17}}, rotation = 0)));
equation
  connect(bus2.p, pwLine1.n) annotation(
    Line(points = {{72, 32}, {68, 32}, {68, 42}, {8, 42}, {8, 42}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine1.p) annotation(
    Line(points = {{-76, 32}, {-72, 32}, {-72, 42}, {-10, 42}, {-10, 42}}, color = {0, 0, 255}));
  connect(bus4.p, pwLine2.n) annotation(
    Line(points = {{72, -22}, {66, -22}, {66, -30}, {8, -30}, {8, -30}}, color = {0, 0, 255}));
  connect(bus3.p, pwLine2.p) annotation(
    Line(points = {{-76, -20}, {-70, -20}, {-70, -30}, {-10, -30}, {-10, -30}}, color = {0, 0, 255}));
  connect(bus3.p, pwLine3.n) annotation(
    Line(points = {{-76, -20}, {-70, -20}, {-70, -12}, {0, -12}, {0, -4}, {0, -4}}, color = {0, 0, 255}));
  connect(bus2.p, pwLine3.p) annotation(
    Line(points = {{72, 32}, {68, 32}, {68, 22}, {0, 22}, {0, 14}, {0, 14}}, color = {0, 0, 255}));
  connect(bus4.p, voltDependant4.p) annotation(
    Line(points = {{72, -22}, {78, -22}, {78, -40}, {114, -40}, {114, -52}, {116, -52}}, color = {0, 0, 255}));
  connect(bus4.p, order24.p) annotation(
    Line(points = {{72, -22}, {72, -68}}, color = {0, 0, 255}));
  connect(order24.vf0, order24.vf) annotation(
    Line(points = {{61, -86}, {55, -86}, {55, -96}, {65, -96}, {65, -90}, {67, -90}}, color = {0, 0, 127}));
  connect(order24.pm0, order24.pm) annotation(
    Line(points = {{83, -86}, {87, -86}, {87, -96}, {77, -96}, {77, -90}, {77, -90}}, color = {0, 0, 127}));
  connect(pwLine4.n, bus4.p) annotation(
    Line(points = {{72, -11}, {72, -22}}, color = {0, 0, 255}));
  connect(bus2.p, pwLine4.p) annotation(
    Line(points = {{72, 32}, {72, 7}}, color = {0, 0, 255}));
  connect(voltDependant3.p, bus3.p) annotation(
    Line(points = {{-111, -54}, {-110, -54}, {-110, -38}, {-82, -38}, {-82, -20}, {-76, -20}}, color = {0, 0, 255}));
  connect(bus3.p, order23.p) annotation(
    Line(points = {{-76, -20}, {-76, -70}}, color = {0, 0, 255}));
  connect(pwLine5.n, bus3.p) annotation(
    Line(points = {{-76, -9}, {-76, -20}}, color = {0, 0, 255}));
  connect(voltDependant2.p, bus2.p) annotation(
    Line(points = {{80, 44}, {78, 44}, {78, 32}, {72, 32}}, color = {0, 0, 255}));
  connect(order22.p, bus2.p) annotation(
    Line(points = {{72, 64}, {72, 32}}, color = {0, 0, 255}));
  connect(order22.vf, order22.vf0) annotation(
    Line(points = {{77, 86}, {77, 86}, {77, 92}, {87, 92}, {87, 82}, {83, 82}, {83, 82}}, color = {0, 0, 127}));
  connect(order22.pm, order22.pm0) annotation(
    Line(points = {{67, 86}, {65, 86}, {65, 92}, {55, 92}, {55, 82}, {61, 82}, {61, 82}}, color = {0, 0, 127}));
  connect(voltDependant1.p, bus1.p) annotation(
    Line(points = {{-83, 46}, {-82, 46}, {-82, 32}, {-76, 32}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine5.p) annotation(
    Line(points = {{-76, 32}, {-76, 9}}, color = {0, 0, 255}));
  connect(order21.p, bus1.p) annotation(
    Line(points = {{-76, 64}, {-76, 32}}, color = {0, 0, 255}));
  connect(order23.pm0, order23.pm) annotation(
    Line(points = {{-65, -88}, {-61, -88}, {-61, -98}, {-71, -98}, {-71, -92}, {-71, -92}}, color = {0, 0, 127}));
  connect(order23.vf0, order23.vf) annotation(
    Line(points = {{-87, -88}, {-93, -88}, {-93, -98}, {-83, -98}, {-83, -92}, {-81, -92}}, color = {0, 0, 127}));
  connect(order21.vf, order21.vf0) annotation(
    Line(points = {{-71, 86}, {-73, 86}, {-73, 92}, {-61, 92}, {-61, 82}, {-65, 82}}, color = {0, 0, 127}));
  connect(order21.pm0, order21.pm) annotation(
    Line(points = {{-87, 82}, {-93, 82}, {-93, 82}, {-95, 82}, {-95, 92}, {-83, 92}, {-83, 86}, {-81, 86}}, color = {0, 0, 127}));
annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");
end Ex6_1;
