model Ex6_10
OpenIPSL.Electrical.Buses.Bus bus1(V_0 = 1.04, angle_0 = 0, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-48, 32}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus2(V_0 = 1, angle_0 = 0, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {52, 32}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus3(V_0 = 1.04, angle_0 = 0, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {6, -32}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order21 annotation(
    Placement(visible = true, transformation(origin = {-47, 75}, extent = {{-7, -7}, {7, 7}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order22 annotation(
    Placement(visible = true, transformation(origin = {51, 73}, extent = {{-7, -7}, {7, 7}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order23 annotation(
    Placement(visible = true, transformation(origin = {9, -71}, extent = {{-7, -7}, {7, 7}}, rotation = 90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1 annotation(
    Placement(visible = true, transformation(origin = {2, 42}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2 annotation(
    Placement(visible = true, transformation(origin = {-48, 4}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3 annotation(
    Placement(visible = true, transformation(origin = {52, 4}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant1 annotation(
    Placement(visible = true, transformation(origin = {-76, 66}, extent = {{-6, -6}, {6, 6}}, rotation = 180)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant2 annotation(
    Placement(visible = true, transformation(origin = {78, 66}, extent = {{-6, 6}, {6, -6}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant3 annotation(
    Placement(visible = true, transformation(origin = {-30, -58}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));

  constant Real pi = 2 * Modelica.Math.asin(1.0);   // 3.14159265358979 in radian;
  parameter Real R2D = 180 / pi"Radian to degree conversion";
  parameter Real D2R = pi / 180"Degree to radian conversion";  
  parameter Real V1(unit = "pu")=1.04"bus 1 voltage";
  parameter Real V2(unit = "pu")=1"bus 2 voltage";
  parameter Real V3(unit = "pu")=1.04"bus 3 voltage";
  parameter Real delta1(unit = "degree")=0"voltage angle of bus1";
  parameter Real delta3(unit = "degree")=0"voltage angle of bus2";
  parameter Real delta2(unit = "degree")=0"voltage angle of bus2 assuming this value";
  parameter Real P2_sp(unit = "pu")=0.5"specified value of real power of bus2";
  parameter Real P3_sp(unit = "pu")=-1.5"specified value of real power of bus3";
  parameter Real Q2_sp(unit = "pu")=1"specified value of reactive power of bus2";
  parameter Real Q_D3(unit = "pu")=0.6"reactive load demand demand of bus 3";
  parameter Complex tolerance=Complex(0,0.01)"tolerance in pu";
  parameter Complex Z_series=Complex(0.02,0.08)"series impedance in pu";
  parameter Complex Y_shunt=Complex(0,0.02)"shunt admittance in pu";
  parameter Complex Y_series=(1/Z_series)"series admittance in pu";
  parameter Real Y_series_abs(unit = "pu") = (Y_series.re ^ 2 + Y_series.im ^ 2) ^ 0.5"absolute value of series admittance";
  parameter Real Y_series_arg(unit = "degree") = atan(Y_series.im / Y_series.re) * R2D "angle of series admittance";
  parameter Real Y_series_arg1(unit = "degree") = Y_series_arg + 180"angle of series admittance";
  parameter Complex Y1=-Y_series"each off diagonal term in pu";
  parameter Complex Y2=2*(Y_series+tolerance)"each self term in pu";
  parameter Real Y2_abs(unit = "pu") = (Y2.re ^ 2 + Y2.im ^ 2) ^ 0.5"absolute value of each self term";
  parameter Real Y2_arg(unit = "degree") = atan(Y2.im / Y2.re) * R2D "angle of each self term";
  parameter Complex [3,3]Y_bus={{Y2,Y_series,Y_series},{Y_series,Y2,Y_series},{Y_series,Y_series,Y2}}"complex bus admittances in matrix form";
  parameter Real P2(unit = "pu")=(V2*V1*Y_series_abs*cos(Y_series_arg1*D2R+delta1-delta2))+((V2^2)*Y2_abs*cos(Y2_arg*D2R))+(V2*V3*Y_series_abs*cos(Y_series_arg1*D2R+delta3-delta2))"real power of bus2";
  parameter Real P3(unit = "pu")=(V3*V1*Y_series_abs*cos(Y_series_arg1*D2R+delta1-delta3))+(V2*V3*Y_series_abs*cos(Y_series_arg1*D2R+delta2-delta3))+((V3^2)*Y2_abs*cos(Y2_arg*D2R))"real power of bus3";
  parameter Real Q2(unit = "pu")=(-V2*V1*Y_series_abs*sin(Y_series_arg1*D2R+delta1-delta2))-((V2^2)*Y2_abs*sin(Y2_arg*D2R))-(V2*V3*Y_series_abs*sin(Y_series_arg1*D2R+delta3-delta2))"reactive power of bus2";
  parameter Real delP2(unit = "pu")=P2_sp-P2"power residual";
  parameter Real delP3(unit = "pu")=P3_sp-P3"power residual";
  parameter Real delQ2(unit = "pu")=Q2_sp-Q2"power residual";
  //Jacobian elements are obtained by differentiating the expressions as follows
  parameter Real[3, 3] J = {{24.47, -12.23, 5.64}, {-12.23, 24.95, -3.05}, {-6.11, 3.05, 22.54}} "Jacobian matrix";
  parameter Real [3,3]J_inv=Modelica.Math.Matrices.inv(J)"inverse of Jacobian matrix";
  parameter Real [3,1]P={{delP2},{delP3},{delQ2}}"power residuals in matrix form";
  parameter Real [3,1]C=J_inv*P"matrix of changed parameters";
  parameter Real del_delta2_1(unit = "degree")=C[1,1]"change in voltage angle of bus2";
  parameter Real del_delta3_1(unit = "degree")=C[2,1]"change in voltage angle of bus3";
  parameter Real del_V2_1(unit = "pu")=C[3,1]"change in voltage of bus2";
  parameter Real [3,1]I={{0},{0},{1}}"initial values of parameters in matrix form";
  parameter Real [3,1]M=I+C"final values of parameters after itteration in matrix form";
  parameter Real delta2_1(unit = "degree")=M[1,1]"update voltage angle of bus2";
  parameter Real delta3_1(unit = "degree")=M[2,1]"update voltage angle of bus3";
  parameter Real V2_1(unit = "pu")=M[3,1]"update voltage of bus2";
  parameter Real Q3(unit = "pu")=(-V3*V1*Y_series_abs*sin(Y_series_arg1*D2R+delta1-delta3))-(V2*V3*Y_series_abs*sin(Y_series_arg1*D2R+delta2-delta3))-((V3^2)*Y2_abs*sin(Y2_arg*D2R))"reactive voltage of bus3";
  parameter Real QG3_1(unit = "pu")=Q3+Q_D3"reactive power generation of bus3";
  inner OpenIPSL.Electrical.SystemBase SysData annotation(
    Placement(visible = true, transformation(origin = {-154, 66}, extent = {{-16, -18}, {16, 18}}, rotation = 0)));  equation
  connect(order22.pm, order22.pm0) annotation(
    Line(points = {{47.5, 81.4}, {45.5, 81.4}, {45.5, 87.4}, {35.5, 87.4}, {35.5, 77.4}, {43.5, 77.4}, {43.5, 77.4}}, color = {0, 0, 127}));
  connect(order22.vf, order22.vf0) annotation(
    Line(points = {{54.5, 81.4}, {54.5, 81.4}, {54.5, 87.4}, {64.5, 87.4}, {64.5, 77.4}, {58.5, 77.4}, {58.5, 77.4}}, color = {0, 0, 127}));
  connect(order22.p, bus2.p) annotation(
    Line(points = {{51, 66}, {51, 32}, {52, 32}}, color = {0, 0, 255}));
  connect(bus1.p, voltDependant1.p) annotation(
    Line(points = {{-48, 32}, {-52, 32}, {-52, 50}, {-76, 50}, {-76, 60}}, color = {0, 0, 255}));
  connect(bus3.p, pwLine2.n) annotation(
    Line(points = {{6, -32}, {6, -20}, {-48, -20}, {-48, -4}}, color = {0, 0, 255}));
  connect(bus3.p, pwLine3.n) annotation(
    Line(points = {{6, -32}, {12, -32}, {12, -20}, {52, -20}, {52, -5}}, color = {0, 0, 255}));
  connect(bus3.p, order23.p) annotation(
    Line(points = {{6, -32}, {10, -32}, {10, -64}}, color = {0, 0, 255}));
  connect(voltDependant3.p, bus3.p) annotation(
    Line(points = {{-30, -52}, {-30, -44}, {6, -44}, {6, -32}}, color = {0, 0, 255}));
  connect(bus2.p, pwLine3.p) annotation(
    Line(points = {{52, 32}, {52, 13}}, color = {0, 0, 255}));
  connect(pwLine1.n, bus2.p) annotation(
    Line(points = {{12, 42}, {44, 42}, {44, 32}, {52, 32}, {52, 32}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine1.p) annotation(
    Line(points = {{-48, 32}, {-44, 32}, {-44, 42}, {-6, 42}, {-6, 42}}, color = {0, 0, 255}));
  connect(order21.pm, order21.pm0) annotation(
    Line(points = {{-50, 84}, {-50, 84}, {-50, 90}, {-60, 90}, {-60, 80}, {-54, 80}, {-54, 80}}, color = {0, 0, 127}));
  connect(order21.vf, order21.vf0) annotation(
    Line(points = {{-44, 84}, {-44, 84}, {-44, 90}, {-34, 90}, {-34, 80}, {-40, 80}, {-40, 80}}, color = {0, 0, 127}));
  connect(order23.pm, order23.pm0) annotation(
    Line(points = {{12, -80}, {12, -80}, {12, -86}, {20, -86}, {20, -76}, {16, -76}, {16, -76}}, color = {0, 0, 127}));
  connect(order23.vf, order23.vf0) annotation(
    Line(points = {{6, -80}, {6, -80}, {6, -86}, {-2, -86}, {-2, -76}, {2, -76}, {2, -76}}, color = {0, 0, 127}));
  connect(order21.p, bus1.p) annotation(
    Line(points = {{-46, 68}, {-48, 68}, {-48, 32}, {-48, 32}}, color = {0, 0, 255}));
  connect(bus2.p, voltDependant2.p) annotation(
    Line(points = {{52, 32}, {54, 32}, {54, 48}, {78, 48}, {78, 60}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine2.p) annotation(
    Line(points = {{-48, 32}, {-48, 13}}, color = {0, 0, 255}));
//The answers may slightly vary due to rounding off values. The same problem can be solved by using different tools also.
  annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");
end Ex6_10;
