model Ex6_6
constant Real pi = 2 * Modelica.Math.asin(1.0)"in radian";
parameter Real R2D = 180 / pi"Radian to degree conversion";
parameter Real D2R = pi / 180"Degree to radian conversion";
parameter Real modv(unit = "pu")=1"voltage of reference bus";
parameter Real P_D2=0.5"real power at bus2";
parameter Real theta(unit = "radian")=pi/2"value of angle theta";
parameter Complex Q2=Complex(0,0.2)"recative power at bus2";
//Applying Shridhar Acharya formula to obtain V2
parameter Real A=4;
parameter Real B=-4.8;
parameter Real C=((P_D2^2)+0.04);
parameter Real V2_square1(unit = "pu")=(-B+(((B^2)-(4*A*C))^0.5))/(2*A)"allowing positive sign";
parameter Real V2_1(unit = "pu")=V2_square1^0.5"voltage at bus2";
parameter Real V2_square2(unit = "pu")=(-B-(((B^2)-(4*A*C))^0.5))/(2*A)"allowing negative sign";
parameter Real V2_2(unit = "pu")=V2_square2^0.5"voltage at bus2";
parameter Real V2(unit = "pu")=V2_1"accepted value of voltage at bus2";
parameter Real delta2(unit = "degree")=(acos(P_D2/(2*V2_1))-theta)*R2D"value of angle delta2";
parameter Complex S2=-P_D2+Q2"complex power injected at bus 2";
parameter Complex S1=-S2"complex power injected at bus 1";
//The answers may slightly vary due to rounding off values.  
end Ex6_6;
