model Ex6_7
OpenIPSL.Electrical.Machines.PSAT.Order2 order21(D = 0, M = 8, Sn = 100, Vn = 400, ra = 1, x1d = 0.07)  annotation(
    Placement(visible = true, transformation(origin = {-66, 70}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
 OpenIPSL.Electrical.Machines.PSAT.Order2 order22(D = 0, M = 8, Sn = 100, Vn = 400, ra = -2, x1d = 0.132)  annotation(
    Placement(visible = true, transformation(origin = {64, 72}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
 OpenIPSL.Electrical.Machines.PSAT.Order2 order23(D = 0, M = 8, Sn = 100, Vn = 400, ra = -2, x1d = 0.132)  annotation(
    Placement(visible = true, transformation(origin = {-66, -54}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
 OpenIPSL.Electrical.Machines.PSAT.Order2 order24(D = 0, M = 8, Sn = 100, Vn = 400, ra = 3, x1d = 0.22)  annotation(
    Placement(visible = true, transformation(origin = {64, -54}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
 OpenIPSL.Electrical.Buses.Bus bus1(V_0 = 1, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-66, 38}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
 OpenIPSL.Electrical.Buses.Bus bus3(V_0 = 1, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {64, 38}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
 OpenIPSL.Electrical.Buses.Bus bus4(V_0 = 1, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-66, -20}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
 OpenIPSL.Electrical.Buses.Bus bus2(V_0 = 1, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {64, -20}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
 OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = 0.15)  annotation(
    Placement(visible = true, transformation(origin = {-2, 50}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
 OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = 0.15)  annotation(
    Placement(visible = true, transformation(origin = {-2, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
 OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0, X = 0.1)  annotation(
    Placement(visible = true, transformation(origin = {-66, 10}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
 OpenIPSL.Electrical.Branches.PwLine pwLine4(B = 0, G = 0, R = 0, X = 0.2)  annotation(
    Placement(visible = true, transformation(origin = {0, 8}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
 OpenIPSL.Electrical.Branches.PwLine pwLine5(B = 0, G = 0, R = 0, X = 0.1)  annotation(
    Placement(visible = true, transformation(origin = {64, 12}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
constant Real pi = 2 * Modelica.Math.asin(1.0);   // 3.14159265358979 in radian;
parameter Real D2R = pi / 180"Degree to radian conversion";
parameter Real R2D = 180 / pi"Radian to degree conversion";
parameter Complex X13=Complex(0,0.15)"reactance of power line1 in pu";
parameter Complex X12=Complex(0,0.2)"reactance of power line4 in pu";
parameter Complex X14=Complex(0,0.1)"reactance of power line5 in pu";
parameter Real modV1(unit = "pu")=1"bus 1 voltage";
parameter Real modV2(unit = "pu")=1"bus 2 voltage";
parameter Real modV3(unit = "pu")=1"bus 3 voltage";
parameter Real modV4(unit = "pu")=1"bus 4 voltage";
parameter Real P2(unit = "pu")=-P_D2+P_G2"bus 2 power";
parameter Real P3(unit = "pu")=-P_D3+P_G3"bus 3 power";
parameter Real P4(unit = "pu")=-P_D4+P_G4"bus4 power";
parameter Real delta1(unit = "degree")=0"voltage angle of bus1";
parameter Real P_D1(unit = "pu")=1"real demand of bus1";
parameter Real P_D2(unit = "pu")=1"real demand of bus2";
parameter Real P_D3(unit = "pu")=2"real demand of bus3";
parameter Real P_D4(unit = "pu")=2"real demand of bus4";
parameter Complex Q_D1=Complex(0,0.5)"reactive demand of bus1 in pu";
parameter Complex Q_D2=Complex(0,0.4)"reactive demand of bus2 in pu";
parameter Complex Q_D3=Complex(0,1)"reactive demand of bus3 in pu";
parameter Complex Q_D4=Complex(0,1)"reactive demand of bus4 in pu";
parameter Complex QD_total=Q_D1+Q_D2+Q_D3+Q_D4"total reactive demand in pu";
parameter Real P_G2(unit = "pu")=4"Real power generation at bus 2";
parameter Real P_G3(unit = "pu")=0"Real power generation at bus 3";
parameter Real P_G4(unit = "pu")=0"Real power generation at bus 4";
parameter Real P_G1(unit = "pu")=P_D1+P_D2+P_D3+P_D4-P_G2"Real power generation at bus 1";
Real [4,4]Y_bus1={{-21.667,5,6.667,10},{5,-21.667,10,6.667},{6.667,10,-16.667,0},{10,6.667,0,-16.667}}"bus admittances in matrix form";
Complex [4,4]Y_bus=Complex(0,Y_bus1)"complex bus admittances in matrix form";
 //Rearranging the equations we have
  parameter Real delta2(unit = "radian")=((3*16.667)-20-(2*6.667))/((21.667*16.667)-(6.667^2)-100)"bus2 voltage angle";
parameter Real delta2_new(unit = "degree")=delta2*R2D"bus2 voltage angle";
parameter Real delta3(unit = "radian")=(-2+(10*delta2))/(16.667)"bus3 voltage angle";
parameter Real delta3_new(unit = "degree")=delta3*R2D"bus3 voltage angle";
parameter Real delta4(unit = "radian")=(-2+(6.667*delta2))/(16.667)"bus4 voltage angle";
parameter Real delta4_new(unit = "degree")=delta4*R2D"bus4 voltage angle";
Real Q1(unit = "pu")=-Y_bus1[1,1]-Y_bus1[1,2]*cos(delta2)-Y_bus1[1,3]*cos(delta3)-Y_bus1[1,4]*cos(delta4)"reactive power at bus1";
Real Q2(unit = "pu")=-Y_bus1[2,2]-Y_bus1[2,1]*cos(delta2)-Y_bus1[2,3]*cos(delta2-delta3)-Y_bus1[2,4]*cos(delta2-delta4)"reactive power at bus2";
Real Q3(unit = "pu")=-Y_bus1[3,3]-Y_bus1[3,1]*cos(delta3)-Y_bus1[3,2]*cos(delta2-delta3)"reactive power at bus3";
Real Q4(unit = "pu")=-Y_bus1[4,4]-Y_bus1[4,1]*cos(delta4)-Y_bus1[4,2]*cos(delta2-delta4)"reactive power at bus4";
Real Q_g1(unit = "pu")=Q1+0.5"Reactive power generations at the bus1";
Real Q_g2(unit = "pu")=Q2+0.4"Reactive power generations at the bus2";
Real Q_g3(unit = "pu")=Q3+1"Reactive power generations at the bus3";
Real Q_g4(unit = "pu")=Q4+1"Reactive power generations at the bus4";
Real Qg_total(unit = "pu")=Q_g1+Q_g2+Q_g3+Q_g4"total reactive power generations at 4 buses";
Real Ql(unit = "pu")=-QD_total.im+Qg_total"reactive power at line";
parameter Real P13(unit = "pu")=sin(delta1-delta3)/X13.im"Real power flow from bus1 to bus3";
parameter Real P31(unit = "pu")=-P13"Real power flow from bus3 to bus1";
parameter Real P12(unit = "pu")=sin(delta1-delta2)/X12.im"Real power flow from bus1 to bus2";
parameter Real P21(unit = "pu")=-P12"Real power flow from bus2 to bus1";
parameter Real P14(unit = "pu")=sin(delta1-delta4)/X14.im"Real power flow from bus1 to bus4";
parameter Real P41(unit = "pu")=-P14"Real power flow from bus4 to bus1";
parameter Real Q12(unit = "pu")=((modV1^2)/X12.im)-((modV1*modV2)*(cos(delta1-delta2)/X12.im))"Reactive power flow from bus1 to bus2";
parameter Real Q21(unit = "pu")=Q12"Reactive power flow from bus2 to bus1";
parameter Real Q13(unit = "pu")=((modV1^2)/X13.im)-((modV1*modV3)*(cos(delta1-delta3)/X13.im))"Reactive power flow from bus1 to bus3";
parameter Real Q31(unit = "pu")=Q13"Reactive power flow from bus3 to bus1";
parameter Real Q14(unit = "pu")=((modV1^2)/X14.im)-((modV1*modV4)*(cos(delta1-delta4)/X14.im))"Reactive power flow from bus1 to bus4";
parameter Real Q41(unit = "pu")=Q14"Reactive power flow from bus4 to bus1";
  inner OpenIPSL.Electrical.SystemBase SysData annotation(
    Placement(visible = true, transformation(origin = {-160, 69}, extent = {{-20, -17}, {20, 17}}, rotation = 0)));  equation
  connect(bus3.p, pwLine1.n) annotation(
    Line(points = {{64, 38}, {60, 38}, {60, 50}, {8, 50}, {8, 50}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine1.p) annotation(
    Line(points = {{-66, 38}, {-62, 38}, {-62, 50}, {-10, 50}, {-10, 50}}, color = {0, 0, 255}));
 connect(bus1.p, pwLine4.p) annotation(
    Line(points = {{-66, 38}, {-62, 38}, {-62, 26}, {0, 26}, {0, 17}}, color = {0, 0, 255}));
 connect(pwLine4.n, bus2.p) annotation(
    Line(points = {{0, -1}, {0, -8}, {62, -8}, {62, -20}, {64, -20}}, color = {0, 0, 255}));
  connect(order23.p, bus4.p) annotation(
    Line(points = {{-66, -44}, {-66, -20}}, color = {0, 0, 255}));
  connect(order23.vf, order23.vf0) annotation(
    Line(points = {{-71, -66}, {-71, -66}, {-71, -74}, {-83, -74}, {-83, -62}, {-77, -62}, {-77, -62}}, color = {0, 0, 127}));
  connect(order23.pm, order23.pm0) annotation(
    Line(points = {{-61, -66}, {-63, -66}, {-63, -74}, {-51, -74}, {-51, -62}, {-55, -62}, {-55, -62}}, color = {0, 0, 127}));
  connect(pwLine2.p, bus4.p) annotation(
    Line(points = {{-10, -40}, {-58, -40}, {-58, -20}, {-66, -20}}, color = {0, 0, 255}));
  connect(pwLine3.n, bus4.p) annotation(
    Line(points = {{-66, 1}, {-66, -20}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine3.p) annotation(
    Line(points = {{-66, 38}, {-66, 19}}, color = {0, 0, 255}));
  connect(pwLine2.n, bus2.p) annotation(
    Line(points = {{8, -40}, {62, -40}, {62, -20}, {64, -20}, {64, -20}}, color = {0, 0, 255}));
  connect(order22.vf, order22.vf0) annotation(
    Line(points = {{70, 84}, {70, 84}, {70, 92}, {84, 92}, {84, 80}, {76, 80}, {76, 80}}, color = {0, 0, 127}));
  connect(order22.pm, order22.pm0) annotation(
    Line(points = {{59, 84}, {57, 84}, {57, 92}, {43, 92}, {43, 80}, {53, 80}, {53, 80}}, color = {0, 0, 127}));
 connect(order22.p, bus3.p) annotation(
    Line(points = {{64, 62}, {64, 38}}, color = {0, 0, 255}));
 connect(bus3.p, pwLine5.p) annotation(
    Line(points = {{64, 38}, {64, 21}}, color = {0, 0, 255}));
 connect(pwLine5.n, bus2.p) annotation(
    Line(points = {{64, 3}, {64, -20}}, color = {0, 0, 255}));
  connect(order24.pm, order24.pm0) annotation(
    Line(points = {{70, -66}, {70, -66}, {70, -74}, {82, -74}, {82, -62}, {76, -62}, {76, -62}}, color = {0, 0, 127}));
  connect(order24.vf, order24.vf0) annotation(
    Line(points = {{60, -66}, {60, -66}, {60, -74}, {46, -74}, {46, -62}, {54, -62}, {54, -62}}, color = {0, 0, 127}));
  connect(order21.vf, order21.vf0) annotation(
    Line(points = {{-60, 82}, {-60, 82}, {-60, 90}, {-46, 90}, {-46, 78}, {-54, 78}, {-54, 78}}, color = {0, 0, 127}));
  connect(order21.pm, order21.pm0) annotation(
    Line(points = {{-70, 82}, {-72, 82}, {-72, 90}, {-86, 90}, {-86, 78}, {-76, 78}, {-76, 78}}, color = {0, 0, 127}));
 connect(order24.p, bus2.p) annotation(
    Line(points = {{64, -44}, {64, -20}}, color = {0, 0, 255}));
  connect(order21.p, bus1.p) annotation(
    Line(points = {{-66, 60}, {-66, 60}, {-66, 38}, {-66, 38}}, color = {0, 0, 255}));
//The answers may slightly vary due to rounding off values.
  annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");
end Ex6_7;
