model Ex7_3
parameter Real load(final quantity="Power", final unit="MW")=175"total load";
parameter Real days(final quantity="Time", final unit="days")=365"total days in a year";
parameter Real hrs(final quantity="Time", final unit="hours")=24"total hours in a day";
parameter Real P_g1_max(final quantity="Power", final unit="MW")=87.5"equally distribited load on unit 1";
parameter Real P_g1_min(final quantity="Power", final unit="MW")=100"load that unit 1 shoud take up";
parameter Real P_g2_max(final quantity="Power", final unit="MW")=87.5"equally distribited load on unit 1";
parameter Real P_g2_min(final quantity="Power", final unit="MW")=75"load that unit 1 shoud take up";
parameter Real C1_max(unit = "Rs/h")=(0.1*(P_g1_max^2))+(40*(P_g1_max))"maximum costs of generation for unit 1";
parameter Real C1_min(unit = "Rs/h")=(0.1*(P_g1_min^2))+(40*(P_g1_min))"minimum costs of generation for unit 1";
parameter Real C1(unit = "Rs/h")=C1_max-C1_min"increase in costs of generation for unit 1";
parameter Real C2_max(unit = "Rs/h")=(0.2*(P_g2_max^2))+(30*(P_g2_max))"maximum costs of generation for unit 2";
parameter Real C2_min(unit = "Rs/h")=(0.2*(P_g2_min^2))+(30*(P_g2_min))"minimum costs of generation for unit 2";
parameter Real C2(unit = "Rs/h")=C2_max-C2_min"increase in costs of generation for unit 2";
parameter Real net_saving(unit = "Rs/h")=C1+C2"net saving caused by optimum scheduling";
parameter Real total_yearly_saving(unit = "Rs")= net_saving*days*hrs"total yearly saving assuming continuous operation";
//The answers may slightly vary due to rounding off values.
end Ex7_3;
