model Ex7_4
//case1
parameter Real load1(final quantity="Power", final unit="MW")=290"total load from 6AM to 6PM";
parameter Real h(final quantity="Time", final unit="hours")=12"twelve-hour period";
parameter Real P_g1(final quantity="Power", final unit="MW")=175"output of unit1";
parameter Real P_g2(final quantity="Power", final unit="MW")=load1-P_g1"output of unit2";
parameter Real C1(unit = "Rs")=(0.1*(P_g1^2))+(40*(P_g1))+120"fuel cost of unit1 for twelve-hour period";
parameter Real C2(unit = "Rs")=(0.2*(P_g2^2))+(30*(P_g2))+100"fuel cost of unit2 for twelve-hour period";
parameter Real cost(unit = "Rs")=(C1+C2)*h"total fuel cost";
//case2
parameter Real load2(final quantity="Power", final unit="MW")=70"total load from 6PM to 6AM";
parameter Real h2(final quantity="Time", final unit="hours")=12"twelve-hour period";
parameter Real P_g1_2(final quantity="Power", final unit="MW")=30"output of unit1";
parameter Real P_g2_2(final quantity="Power", final unit="MW")=load2-P_g1_2"output of unit2";
parameter Real C1_2(unit = "Rs")=(0.1*(P_g1_2^2))+(40*(P_g1_2))+120"fuel cost of unit1 for twelve-hour period";
parameter Real C2_2(unit = "Rs")=(0.2*(P_g2_2^2))+(30*(P_g2_2))+100"fuel cost of unit2 for twelve-hour period";
parameter Real cost_2(unit = "Rs")=(C1_2+C2_2)*h2"total fuel cost";
//case3
parameter Real cost_3(unit = "Rs")=cost+cost_2"total fuel cost when both units are operating through 24 hrs";
//case 4: only unit 2 is running
parameter Real service_cost(unit = "Rs")=400"service cost";
parameter Real P_g2_4(final quantity="Power", final unit="MW")=70"output of unit2";
parameter Real h4(final quantity="Time", final unit="hours")=12"twelve-hour period when only unit2 is running and unit1 is put off";
parameter Real cost_4(unit = "Rs")=((0.2*(P_g2_4^2))+(30*(P_g2_4))+100)*h4"total fuel cost during this period";
parameter Real total_fual_cost(unit = "Rs")=cost+cost_4"total fuel cost";
parameter Real cost_total(unit = "Rs")=total_fual_cost+service_cost"total operating cost when only unit2 is running and unit1 is put off";
//case5
parameter Real load5(final quantity="Power", final unit="MW")=55"total changed output load from 6PM to 6AM";
parameter Real h5(final quantity="Time", final unit="hours")=12"twelve-hour period when load is changed";
parameter Real P_g1_5(final quantity="Power", final unit="MW")=30"output of unit1 when load is changed";
parameter Real P_g2_5(final quantity="Power", final unit="MW")=load5-P_g1_5"output of unit2 when load is changed";
parameter Real C1_5(unit = "Rs")=(0.1*(P_g1_5^2))+(40*(P_g1_5))+120"fuel cost of unit1 for twelve-hour period when load is changed";
parameter Real C2_5(unit = "Rs")=(0.2*(P_g2_5^2))+(30*(P_g2_5))+100"fuel cost of unit2 for twelve-hour period when load is changed";
parameter Real cost_5(unit = "Rs")=(C1_5+C2_5)*h5"total fuel cost when load is changed";
parameter Real cost_6(unit = "Rs")=cost+cost_5"total fuel cost when both units are operating through 24 hrs";
//case 6: only unit 2 is running
parameter Real service_cost_6(unit = "Rs")=400"service cost";
parameter Real P_g2_6(final quantity="Power", final unit="MW")=55"output of unit2";
parameter Real h6(final quantity="Time", final unit="hours")=12"twelve-hour period when only unit2 is running and unit1 is put off";
parameter Real cost_7(unit = "Rs")=((0.2*(P_g2_6^2))+(30*(P_g2_6))+100)*h6"total fuel cost during this period";
parameter Real total_fual_cost_6(unit = "Rs")=cost+cost_7"total fuel cost";
parameter Real cost_total_6(unit = "Rs")=total_fual_cost_6+service_cost_6"total operating cost when only unit2 is running and unit1 is put off";
//The answers may slightly vary due to rounding off values.
end Ex7_4;
