model Ex9_3
OpenIPSL.Electrical.Machines.PSAT.Order2 generator1(D = 0, M = 8, Sn = S_n, V_b = Vb, Vn = 11, ra = 0, x1d = X1)  annotation(
    Placement(visible = true, transformation(origin = {-134, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 motor(D = 0, M = 8, Sn = S_n, V_b = Vb, Vn = 11, ra = 0, x1d = X1)  annotation(
    Placement(visible = true, transformation(origin = {138, 0}, extent = {{10, 10}, {-10, -10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1(displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-98, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2 annotation(
    Placement(visible = true, transformation(origin = {96, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(r = 0, x = 0.1)  annotation(
    Placement(visible = true, transformation(origin = {-66, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0.1, X = 0.1)  annotation(
    Placement(visible = true, transformation(origin = {-2, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2(r = 0, x = 0.1)  annotation(
    Placement(visible = true, transformation(origin = {66, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  inner OpenIPSL.Electrical.SystemBase SysData(S_b = S_n, fn = 50)  annotation(
    Placement(visible = true, transformation(origin = {-154, 71}, extent = {{-20, -17}, {20, 17}}, rotation = 0)));
  OpenIPSL.Electrical.Events.PwFault pwFault1(R = 0, X = 1.2, t1 = 10, t2 = 25)  annotation(
    Placement(visible = true, transformation(origin = {118, -38}, extent = {{-6, -6}, {6, 6}}, rotation = -90)));

constant Real pi = 2 * Modelica.Math.asin(1.0);   // 3.14159265358979 in radian;
  parameter Real R2D = 180 / pi"Radian to degree conversion";
parameter Real D2R = pi / 180"Degree to radian conversion";
parameter Real l(final quantity="Power", final unit="MW")=15"load";
parameter Real Vt(final quantity="ElectricPotential", final unit="kV")=10.6"terminal voltage";
parameter Real S_n(final quantity="Power", final unit="MVA")=25"system base";
parameter Real Vb(final quantity="ElectricPotential", final unit="kV")=11"base voltage";
parameter Real pf=0.8"power factor";
parameter Real X1(unit = "pu")=0.15"reactances of generator and motor";
parameter Complex Xg=Complex(0,3*X1)"reactances of generator in complex form in pu";
parameter Complex Xm=Complex(0,X1)"reactances of motor in complex form in pu";
parameter Real alfa(unit = "degree")=acos(pf)*R2D"power factor angle";
parameter Real V(unit = "pu")=(Vt/Vb)"prefault voltage";
parameter Complex V_pf = Complex(V * cos(0), V * sin(0))"prefault voltage in complex form in pu";
parameter Real V_pf_abs(unit = "pu") = (V_pf.re ^ 2 + V_pf.im ^ 2) ^ 0.5"absolute value of prefault voltage";
parameter Real V_pf_arg(unit = "degree") = atan(V_pf.im / V_pf.re) * R2D "angle of prefault voltage";
parameter Real load(unit = "pu")=l/S_n"load";
parameter Real I_pf1(unit = "pu") = load/(V*pf)"prefault current";
parameter Complex I_pf = Complex(I_pf1 * cos(alfa*D2R), I_pf1 * sin(alfa*D2R))"prefault current in complex form in pu";
parameter Real I_pf_abs(unit = "pu") = (I_pf.re ^ 2 + I_pf.im ^ 2) ^ 0.5"absolute value of prefault current";
parameter Real I_pf_arg(unit = "degree") = atan(I_pf.im / I_pf.re) * R2D "angle of prefault current";
parameter Complex Eg=V_pf+(Xg)*I_pf"voltage behind subtransient reactance of generator in pu";
parameter Complex Em=V_pf-(Xm)*I_pf"voltage behind subtransient reactance of motor in pu";
parameter Complex Ig=Eg/Xg"subtransient current in generator under fault condition in pu";
parameter Complex Im=Em/Xm"subtransient current in motor under fault condition in pu";
parameter Complex If=Ig+Im"subtransient fault current in pu";
parameter Modelica.SIunits.Current Ibase=(S_n*1e3)/((3^0.5)*Vb)"base current";
parameter Modelica.SIunits.ComplexCurrent Ig1=Ig*Ibase"subtransient current in generator under fault condition";
parameter Modelica.SIunits.ComplexCurrent Im1=Im*Ibase"subtransient current in motor under fault condition";
parameter Modelica.SIunits.ComplexCurrent If1=Ig1+Im1"subtransient fault current";
parameter Modelica.SIunits.ComplexCurrent If1_new=Complex(0,If1.im)"subtransient fault current";


OpenIPSL.Electrical.Buses.Bus bus3(displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-38, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus4(displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {30, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(motor.vf, motor.vf0) annotation(
    Line(points = {{150, -5}, {158, -5}, {158, -17}, {146, -17}, {146, -11}}, color = {0, 0, 127}));
  connect(motor.pm, motor.pm0) annotation(
    Line(points = {{150, 5}, {158, 5}, {158, 17}, {146, 17}, {146, 11}}, color = {0, 0, 127}));
  connect(pwLine1.n, bus4.p) annotation(
    Line(points = {{7, 0}, {30, 0}}, color = {0, 0, 255}));
  connect(bus3.p, pwLine1.p) annotation(
    Line(points = {{-38, 0}, {-11, 0}}, color = {0, 0, 255}));
  connect(bus4.p, twoWindingTransformer2.p) annotation(
    Line(points = {{30, 0}, {56, 0}, {56, 0}, {56, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.n, bus2.p) annotation(
    Line(points = {{77, 0}, {96, 0}}, color = {0, 0, 255}));
  connect(bus2.p, motor.p) annotation(
    Line(points = {{96, 0}, {128, 0}}, color = {0, 0, 255}));
  connect(pwFault1.p, motor.p) annotation(
    Line(points = {{118, -31}, {118, 0}, {128, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus3.p) annotation(
    Line(points = {{-54, 0}, {-38, 0}, {-38, 0}, {-38, 0}}, color = {0, 0, 255}));
  connect(bus1.p, twoWindingTransformer1.p) annotation(
    Line(points = {{-98, 0}, {-77, 0}}, color = {0, 0, 255}));
  connect(generator1.p, bus1.p) annotation(
    Line(points = {{-124, 0}, {-98, 0}}, color = {0, 0, 255}));
  connect(generator1.vf0, generator1.vf) annotation(
    Line(points = {{-142, 11}, {-142, 11}, {-142, 17}, {-154, 17}, {-154, 5}, {-146, 5}, {-146, 5}}, color = {0, 0, 127}));
  connect(generator1.pm0, generator1.pm) annotation(
    Line(points = {{-142, -11}, {-142, -11}, {-142, -19}, {-154, -19}, {-154, -7}, {-146, -7}, {-146, -5}}, color = {0, 0, 127}));
annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");
end Ex9_3;
