model Ex9_9
OpenIPSL.Electrical.Machines.PSAT.Order2 generator1(D = 0, M = 8, Sn = 100, Vn = 400, ra = 0, x1d = 0.2) annotation(
    Placement(visible = true, transformation(origin = {-146, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator2(D = 0, M = 8, Sn = 100, Vn = 400, ra = 0, x1d = 0.2) annotation(
    Placement(visible = true, transformation(origin = {146, 0}, extent = {{10, 10}, {-10, -10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus annotation(
    Placement(visible = true, transformation(origin = {-112, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus0 annotation(
    Placement(visible = true, transformation(origin = {114, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(r = 0, x = 0.05) annotation(
    Placement(visible = true, transformation(origin = {-86, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2(r = 0, x = 0.05) annotation(
    Placement(visible = true, transformation(origin = {82, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1 annotation(
    Placement(visible = true, transformation(origin = {-48, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2 annotation(
    Placement(visible = true, transformation(origin = {40, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus3 annotation(
    Placement(visible = true, transformation(origin = {4, -60}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = 0.1) annotation(
    Placement(visible = true, transformation(origin = {-2, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = 0.1) annotation(
    Placement(visible = true, transformation(origin = {-54, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0, X = 0.1) annotation(
    Placement(visible = true, transformation(origin = {46, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Events.PwFault pwFault1(R = 0, X = 0.2, t1 = 5, t2 = 40) annotation(
    Placement(visible = true, transformation(origin = {16, -84}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
  parameter Real Z1(unit = "pu") = 0.25"total impedance of generator and transfoemer";
  parameter Real Z2(unit = "pu") = Z1"total impedance of generator and transfoemer";
  parameter Real b12 = 0.1"impedance of powerline1";
  parameter Real b13 = 0.1"impedance of powerline2";
  parameter Real b23 = 0.1"impedance of powerline3";
  parameter Real V_3(unit = "pu") = 1"prefault voltage";
  parameter Real Vf_3(unit = "pu") = 0;
  parameter Real Z_ig(unit = "pu") = 0.2"impedance of each generator";
  parameter Real Z_t(unit = "pu") = 0.05"impedance of each transformer";
  parameter Real E_G1(unit = "pu") = 1"prefault voltage of generator1 at no load";
  parameter Real E_G2(unit = "pu") = 1"prefault voltage of generator2 at no load";
  //step-1
  parameter Real Z_bus_1(unit = "pu") = Z1"bus impedance matrix after adding branch from bus1 to reference bus";
  //step-2
  parameter Real[2, 2] Z_bus_2(unit = "pu") = {{Z1, Z2}, {Z2, Z1 + b12}}"bus impedance matrix after adding branch from bus2 to bus1";
  //step-3
  parameter Real[3, 3] Z_bus_3(unit = "pu") = {{Z1, Z2, Z1}, {Z2, Z1 + b12, Z1}, {Z1, Z2, Z1 + b13}}"bus impedance matrix after adding branch from bus3 to bus1";
  //steep-4
  parameter Real[3, 1] Z_bus_4a(unit = "pu") = {{Z1}, {Z1 + b23}, {Z2}}"bus impedance matrix";
  parameter Real[1, 3] Z_bus_4b(unit = "pu") = transpose(Z_bus_4a)"transpose of matrix Z_bus_4a";
  parameter Real[3, 3] Z_bus_4c(unit = "pu") = Z_bus_4a * Z_bus_4b"product of Z_bus_4a matrix and its transpose";
  parameter Real[3, 3] Z_bus_4(unit = "pu") = Z_bus_3 - 1 / (Z1 + Z2 + b23) * Z_bus_4c"bus impedance matrix after adding branch from bus2 to reference bus";
  //step 5
  parameter Real[3, 1] Z_bus_5a(unit = "pu") = {{Z_bus_4[1, 2] - Z_bus_4[1, 3]}, {(-Z_bus_4[2, 3]) + Z_bus_4[2, 2]}, {Z_bus_4[3, 2] - Z_bus_4[3, 3]}}"bus impedance matrix";
  parameter Real[1, 3] Z_bus_5b(unit = "pu") = transpose(Z_bus_5a)"transpose of matrix Z_bus_5a";
  parameter Real[3, 3] Z_bus_5c(unit = "pu") = Z_bus_5a * Z_bus_5b"product of Z_bus_5a matrix and its transpose";
  parameter Real[3, 3] Z_bus_5(unit = "pu") = Z_bus_4 - 1 / (b23 + Z_bus_4[2, 2] + Z_bus_4[3, 3] - 2 * Z_bus_4[2, 3]) * Z_bus_5c"bus impedance matrix after adding branch from bus2 to bus3";
  //case a
  parameter Complex Z_33 = Complex(0, Z_bus_5[3, 3])"impedance of the circuit under fault";
  parameter Complex If = V_3 / Z_33"fault current";
  //case b
  parameter Complex Z_13 = Complex(0, Z_bus_5[1, 3])"line impedance";
  parameter Complex Z_23 = Complex(0, Z_bus_5[2, 3])"line impedance";
  parameter Complex Vf_1 = 1 - Z_13 / Z_33"voltage at bus1 under fault";
  parameter Complex Vf_2 = 1 - Z_23 / Z_33"voltage at bus2 under fault";
  //case c
  parameter Complex z_12= Complex(0, b12)"line impedance";
  parameter Complex Y_12= 1 / z_12"line admittance";
  parameter Complex z_13 = Complex(0, b13)"line impedance";
  parameter Complex Y_13= 1 / z_13"line admittance";
  parameter Complex I_12 = Y_12 * (Vf_1 - Vf_2)"post fault current in the line1-2 in complex form";
  parameter Complex I_13 = Y_13 * (Vf_1 - Vf_3)"post fault current in the line1-3 in complex form";
  parameter Real I_12_new = I_12.re"post fault current in the line1-2";
  parameter Complex I_13_new =I_13"post fault current in the line1-3";
  //case d
  parameter Complex X_ig = Complex(0, Z_ig)"transient reactance of generator";
  parameter Complex X_t = Complex(0, Z_t)"reactance of transformer";
  parameter Complex If_G1 = (E_G1 - Vf_1) / (X_ig + X_t)"post fault generator1 current";
  parameter Complex If_G2 = ((-E_G2) + Vf_2) / (X_ig + X_t)"post fault generator2 current";
  inner OpenIPSL.Electrical.SystemBase SysData annotation(
    Placement(visible = true, transformation(origin = {-172, 74}, extent = {{-20, -18}, {20, 18}}, rotation = 0)));
equation
  connect(generator2.pm, generator2.pm0) annotation(
    Line(points = {{158, 6}, {166, 6}, {166, 18}, {154, 18}, {154, 12}, {154, 12}}, color = {0, 0, 127}));
  connect(generator2.vf, generator2.vf0) annotation(
    Line(points = {{158, -4}, {166, -4}, {166, -16}, {154, -16}, {154, -10}, {154, -10}}, color = {0, 0, 127}));
  connect(bus2.p, twoWindingTransformer2.p) annotation(
    Line(points = {{40, 0}, {71, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.n, bus0.p) annotation(
    Line(points = {{93, 0}, {114, 0}}, color = {0, 0, 255}));
  connect(bus.p, twoWindingTransformer1.p) annotation(
    Line(points = {{-112, 0}, {-97, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus1.p) annotation(
    Line(points = {{-75, 0}, {-48, 0}}, color = {0, 0, 255}));
  connect(pwLine3.p, bus3.p) annotation(
    Line(points = {{38, -40}, {12, -40}, {12, -60}, {4, -60}, {4, -60}}, color = {0, 0, 255}));
  connect(bus3.p, pwLine2.n) annotation(
    Line(points = {{4, -60}, {-2, -60}, {-2, -40}, {-44, -40}}, color = {0, 0, 255}));
  connect(pwFault1.p, bus3.p) annotation(
    Line(points = {{8, -84}, {4, -84}, {4, -60}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine1.p) annotation(
    Line(points = {{-48, 0}, {-11, 0}}, color = {0, 0, 255}));
  connect(pwLine1.n, bus2.p) annotation(
    Line(points = {{7, 0}, {40, 0}}, color = {0, 0, 255}));
  connect(bus2.p, pwLine3.n) annotation(
    Line(points = {{40, 0}, {40, -6}, {70, -6}, {70, -40}, {55, -40}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine2.p) annotation(
    Line(points = {{-48, 0}, {-48, 0}, {-48, -6}, {-76, -6}, {-76, -40}, {-62, -40}, {-62, -40}}, color = {0, 0, 255}));
  connect(bus0.p, generator2.p) annotation(
    Line(points = {{114, 0}, {136, 0}}, color = {0, 0, 255}));
  connect(generator1.p, bus.p) annotation(
    Line(points = {{-136, 0}, {-112, 0}}, color = {0, 0, 255}));
  connect(generator1.vf, generator1.vf0) annotation(
    Line(points = {{-158, 5}, {-168, 5}, {-168, 19}, {-154, 19}, {-154, 11}, {-154, 11}}, color = {0, 0, 127}));
  connect(generator1.pm, generator1.pm0) annotation(
    Line(points = {{-158, -5}, {-168, -5}, {-168, -19}, {-154, -19}, {-154, -11}, {-154, -11}}, color = {0, 0, 127}));
  annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");

end Ex9_9;
