//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-10: CI Engines Fuel Injection System
//Example: 10.1 Page 
//======================================================

model Ex10_1
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real bsfc (unit= "kg/kWh")=0.3; 
parameter Real bp (unit= "kW")=250;
parameter Real N (unit= "rpm")=1500;
parameter Real CA (unit= "deg")=15;
parameter Real pi1 (unit= "bar")=30;
parameter Real pi2 (unit= "bar")=60;
parameter Real pf1 (unit= "bar")=220;
parameter Real pf2 (unit= "bar")=550;
parameter Real Cd (unit= "")=0.65;
parameter Real df (unit= "kg/m^3")=850;
parameter Real n (unit= "")=4; 
parameter Real x (unit= "")=6; 

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real mf (unit= "kg/min")"Mass flow rate of fuel";
Real F (unit= "kg")"Fuel inkected per cycle per cylinder";
Real s (unit= "s")"Duration of injection";
Real mf1 (unit= "mass of fuel injected per second")"";
Real p1 (unit= "bar")"Pressure difference at beginning";
Real p2 (unit= "bar")"Pressure difference at end";
Real pa (unit= "bar")"Average pressure difference";
Real Af (unit= "mm^2")"Area of cross section of nozzle";
Real do (unit= "mm")"Diameter of orifice";


// Equation Section

equation
mf= bsfc *bp /60; 
F=( mf /(N /2) ) *(1/ x); 
s=( CA /360) /(N /60) ; 
mf1 =F/s; 
p1=pf1 - pi1 ; 
p2=pf2 - pi2 ; 
pa =( p1+p2) /2; 
Af =(mf1 /( Cd *(2* df*pa *10^5) ^(1/2) ) )*10^6;
do =(( Af/n) *(4/ pi) )^(1/2) ; 

end Ex10_1;
