//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-10: CI Engines Fuel Injection System
//Example: 10.4 Page 
//======================================================

model Ex10_4
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real s (unit= "cm")=20; 
parameter Real t1 (unit= "ms")=15.7;
parameter Real pi1 (unit= "bar")=150;
parameter Real pi2 (unit= "bar")=450;
parameter Real p2 (unit= "bar")=15;
parameter Real d1 (unit= "mm")=0.34;
parameter Real s1 (unit= "cm")=20;
parameter Real d2 (unit= "cm")=0.17;
parameter Real t11 (unit= "ms")=12;


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real t2 (unit= "ms")"Time required for spray to penetrate";
Real s2 (unit= "cm")"Penetration of orifice";
Real t21 (unit= "ms")"Time required for spray to penetrate";


// Equation Section

equation
t2 =( t1 *( pi1 -p2) ^(1/2) )/( pi2 -p2) ^(1/2) ; 
s2=d2 *( s1/d1); 
t21 = t11 *( d2/d1); 

end Ex10_4;
