//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-10: CI Engines Fuel Injection System
//Example: 10.6 Page 
//======================================================

model Ex10_6
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real n (unit= "")=4; 
parameter Real N (unit= "rpm")=2500;
parameter Real P (unit= "kW")=90;
parameter Real bsfc (unit= "kg/kWh")=0.28;
parameter Real v (unit= "cc")=3.5;
parameter Real vp (unit= "cc")=2.5;
parameter Real vi (unit= "cc")=2;
parameter Real p1 (unit= "bar")=280;
parameter Real p2 (unit= "bar")=30;
parameter Real df (unit= "kg/m^3")=850;
parameter Real K (unit= "bar")=80e-6;
parameter Real pi (unit= "bar")=1;


final constant Real e=Modelica.Math.exp(1.0);
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real F (unit= "kg")"Fuelconsumption per cycle";
Real F1 (unit= "kg/cycle")"Fuel consumption per cylinder";
Real Vf (unit= "cm^3")"Volume of fuelinjected per cylinder";
Real V1 (unit= "cc")"Total initial volume";
Real V (unit= "cc")"Change in volume due to compression";
Real Vp (unit= "cc")"Volume displaced by plunger";
Real W (unit= "J")"Pump work per cycle";
Real P1 (unit= "kW")"Power lost per cylinder";
Real P2 (unit= "kW")"Total power lost for pumping fuel";


// Equation Section

equation
F=( bsfc *P) /(( N/2) *60) ; 
F1=F/n; 
Vf =( F1/df )*10^6; 
V1=v+vp+vi; 
V=K*V1 *(p1 -pi);
Vp=Vf+V;
W =((1/2) *(p1 -pi) *10^5* V *1e-6)+(( p1 -p2) *10^5* Vf*1e-6); 
P1 =(W*N) /(2*60*1000) ; 
P2=P1 *4; 

end Ex10_6;
