//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-11: Two Stroke Engines
//Example: 11.6 Page 
//======================================================

model Ex11_6
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real S (unit= "m/s")=15; 
parameter Real ps (unit= "bar")=0.35; 
parameter Real pa (unit= "bar")=1.03; 
parameter Real r (unit= "")=18; 
parameter Real t (unit= "deg C")=35; 
parameter Real Rsc (unit= "")=0.9; 
parameter Real ta (unit= "deg C")=15; 
parameter Real nc (unit= "")=0.75; 
parameter Real g (unit= "")=1.4; 
parameter Real R (unit= "J/kgK")=287; 
parameter Real Cp (unit= "J/kgK")=1005; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real pii (unit= "bar")"Scavenging pressure";
Real Ti (unit= "K")"Inlet temp";
Real pr (unit= "")"Ratio of pressure for calculations";
Real di (unit= "kg/m^3")"Density";
Real ai (unit= "m/s")"Sonic velocity";
Real C (unit= "")"Flow coefficient";
Real ds (unit= "kg/m^3")"Density";
Real mep (unit= "bar")"Mean effective pressure";


// Equation Section

equation
pii=ps+pa; 
Ti =(273+ ta)+t; 
pr=pa/pii; 
di =( pii *10^5) /(R*Ti); 
ai =(g*R*Ti) ^(1/2) ; 
C=( Rsc) /(2*((r -1)/r)*( ai/S)*( pii/pa) *((2/(g -1) ) *((( pr)^(2/ g)) -(( pr)^((g +1) /g))))^(1/2) ); 
ds =( pa *10^5) /(R*Ti); 
mep =( ds*Rsc*Cp*Ti *((( pii/pa)^((g -1) /g)) -1)) /(( nc *((r-1) /r)) *10^5); 

end Ex11_6;

