//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-15: Air Capacity and Supercharging
//Example: 15.1 Page 
//======================================================

model Ex15_1
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real Vs (unit= "m^3")=0.0028; 
parameter Real N (unit= "rpm")=3000; 
parameter Real ip (unit= "kW/m^3")=12.5; 
parameter Real nv (unit= "%")=85; 
parameter Real p1 (unit= "bar")=1.013; 
parameter Real T1 (unit= "K")=288; 
parameter Real ni (unit= "%")=74; 
parameter Real pr (unit= "")=1.6; 
parameter Real nm (unit= "%")=78; 
parameter Real g (unit= "")=1.4; 
parameter Real R (unit= "J/kgK")=287; 
parameter Real Cp (unit= "kJ/kgK")=1.005; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real Vs1 (unit= "m^3/min")"Volume swept by piston per minute";
Real Vi (unit= "m^3/min")"Unsupercharged induced volume";
Real p2 (unit= "bar")"Blower delivery pressure";
Real T21 (unit= "K")"Temp after isentropic compression";
Real T2 (unit= "K")"Blower delivery temp";
Real Ve (unit= "m^3/min")"Equivalent volume at 1.013 bar and 15 deg C";
Real nv1 (unit= "%")"Volumetric efficiency of supercharged engine";
Real Vii (unit= "m^3/min")"Increase in induced volume";
Real ipa (unit= "kW")"Increase in ip from air induced";
Real ipi (unit= "kW")"Increase in ip due to increased induction pressure";
Real ipt (unit= "kW")"Total increase";
Real bp (unit= "kW")"Increase in engine bp";
Real ma (unit= "kg/s")"Mass of air delivered per second by blower";
Real P (unit= "kW")"Power input to blower";
Real Pd (unit= "kW")"Power required to drive the blower";
Real bpn (unit= "kW")"Net increase in bp";
Real bpu (unit= "kW")"bp of unsupercharged engine";
Real bpp (unit= "%")"% increase in bp";


// Equation Section

equation
Vs1 =( Vs *(N /2) ); 
Vi =( nv /100) *Vs1; 
p2=pr*p1;
T21 =T1 *( p2/p1) ^((g -1)/g); 
T2=T1 +(( T21 -T1) /(( ni /100) )); 
Ve =( Vs1*p2*T1)/( T2*p1); 
nv1 =( Ve/Vs1 )*100; 
Vii =Ve -Vi;
ipa =ip*Vii; 
ipi =(( p2 -p1) *10^5* Vs1 )/(60*1000) ;
ipt = ipa +ipi; 
bp=ipt *( nm /100) ; 
ma =( p2 *( Vs1 /60) *10^5) /(R*T2); 
P=ma*Cp *(T2 -T1); 
Pd=P/( nm /100) ; 
bpn =bp -Pd; 
bpu =ip*Vi *(80/100) ; 
bpp =( bpn /( bpu )) *100; 

end Ex15_1;
