//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-16: Engine Testing and Performance
//Example: 16.1 Page 
//======================================================

model Ex16_1
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real N (unit= "rpm")=3000; 
parameter Real r (unit= "")=9;
parameter Real l (unit= "cm")=17.2;
parameter Real t (unit= "deg")=20;
parameter Real k (unit= "Three litre spark engine")=3;
parameter Real n (unit= "")=6;


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real Vs (unit= "m^3")"Swept volume per cylinder";
Real d (unit= "m")"Diameter of bore";
Real L (unit= "cm")"Length of stroke";
Real up (unit= "m/s")"Average piston speed";
Real Vc (unit= "cm^3")"Clearance volume";
Real cr (unit= "cm")"Crank radius";
Real R (unit= "")"Ratio of connecting rod length to crank radius";
Real up1 (unit= "m/s")"Piston speed at end of combustion";
Real s (unit= "cm")"Distance beteen crank axis and rist pin";
Real x (unit= "cm")"Distance piston travels from TDC at end of comustion";
Real V (unit= "cm^3")"Instantaneous volume";

// Equation Section

equation
Vs =(k/n) *10e-4; 
d =((( Vs *4) /pi )^(1/3) ); 
L=d *100; 
up =2*d*N /60; 
Vc =(Vs /(r -1) )*10^6; 
cr =(L) /2; 
R=l/cr; 
up1 =up *(( pi /2) *sin(pi/9)*(1+(cos(pi/9)/(R^2-(sin(pi/9)^2))^(1/2))));
s=( cr*cos(pi/9))+(l^2-(cr^2)*(sin(pi/9))^2)^(1/2);
x=l+cr -s; 
V=Vc +( pi /4) *(d *100) ^2* x; 

end Ex16_1;
