//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-02: Air Standard Cycles and their Analysis
//Example: 02.6 Page 
//======================================================

model Ex2_6
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real m (unit= "")=30; //Air fuel ratio by mass
parameter Real T1 (unit= "K")=300; //Temperature of air at the beginning of compression
parameter Real r (unit= "")=16; // Compression ratio
parameter Real CV (unit= "kJ/kg")=42000; // Calorific value of fuel
parameter Real g (unit= "")=1.4; // Isentropic index
parameter Real Cp (unit= "kJ/kgK")=1.005; //Specific heat at constant pressure


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real T2 (unit= "K")"Temperature at point 2";
Real T3 (unit= "K")"Temperature at point 3";
Real C (unit= "")"Cut off ratio";
Real n (unit= "")"Ideal efficiency of engine based on ai standard cycle";


// Equation Section

equation
T2=T1 *(r^(g -1)); 
T3 =((1/ m)*( CV/Cp))+ T2; 
C=T3/T2; 
n =(1 -((1/ r^(g -1)) *((( C^g) -1) /(g*(C -1)) ))) *100; 

end Ex2_6;
