//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-03: Reactive Systems
//Example: 03.10 Page 
//======================================================

model Ex3_10
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real T (unit= "K")=1500; 

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real hfco (unit= "MJ/kmol")"Enthalpy of formation forcarbondioxide";
Real hf1 (unit= "MJ/kmol")"Change in enthalpy for actual state and refrence state";
Real HP (unit= "MJ/kmol")"Total enthalpy in the products side";
Real hfc (unit= "MJ/kmol")"Enthalpy of formation for carbonmonoxide";
Real hf2 (unit= "MJ/kmol")"Change in enthalpy of CO for actual and refrence state";
Real hfo (unit= "MJ/kmol")"Enthalpy of formation for oxygen gas";
Real hf3 (unit= "MJ/kmol")"Change in enthalpy of oxygen for different states";
Real HR (unit= "MJ/kmol")"Total enthalpy in reactants side";
Real H (unit= "MJ/kmol")"Enthalpy of combustion";


// Equation Section

equation
hfco = -393.52; 
hf1 =61.714; 
HP= hfco + hf1 ; 
hfc = -110.52; 
hf2 =38.848; 
hfo =0; 
hf3 =40.61; 
HR =( hfc+ hf2) +(0.5*( hfo +hf3)); 
H=HP -HR; 

end Ex3_10;
