//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-03: Reactive Systems
//Example: 03.11 Page 
//======================================================

model Ex3_11
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real E (unit= "%")=30; //Amount of excess air
parameter Real tp (unit= "K")=400; //Temp at which propane enters
parameter Real ta (unit= "K")=300; //Temp at which air enters
parameter Real T (unit= "K")=900; //Temp at which products leave
parameter Real m (unit= "kJ/kmolK")=83.7;// Average molar specific heat of propane at constant pressure 
parameter Real Mp (unit= "")=44;// Molecular weight of propane 

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real hfc (unit= "MJ/kmol")"Enthalpy of formation for CO2";
Real hf1 (unit= "MJ/kmol")"Change in enthalpy of CO2 for actual and reference state";
Real hfh (unit= "MJ/kmol")"Enthalpy of for water";
Real hf2 (unit= "MJ/kmol")"Change in enthalpy of water for actual and reference state";
Real hfn (unit= "MJ/kmol")"Enthalpy of nitrogen gas";
Real hf3 (unit= "MJ/kmol")"Change in enthalpy for nitrogen gas for actual and reference state";
Real hfo (unit= "MJ/kmol")"Enthalpy of oxygen gas";
Real hf4 (unit= "MJ/kmol")"Change in enthalpy of oxygen for actual and reference state";
Real HP (unit= "MJ/kmol")"Total enthalpy in products side";
Real hfp (unit= "MJ/kmol")"Enthalpy of formation for propane";
Real R (unit= "")"Universal gas constant";
Real hfo1 (unit= "MJ/kmol")"Enthalpy of oxygen gas";
Real hf11 (unit= "MJ/kmol")"Change in enthalpy for oxygen gas for actual and reference state";
Real hfn1 (unit= "MJ/kmol")"Enthalpy ofnitrogen gas";
Real hfn22 (unit= "MJ/kmol")"Change in enthalpy for nitrogen for actual and reference state";
Real HR (unit= "MJ/kmol")"Total enthalpy on reactants side";
Real Q (unit= "MJ/kmol")"Amount of heat liberated";
Real Q1 (unit= "MJ/kg")"Amount of heat liberated";

// Equation Section

equation

hfc = -393.52; 
hf1 =28.041; 
hfh = -241.82; 
hf2 =21.924;
hfn =0; 
hf3 =18.221; 
hfo =0; 
hf4 =19.246; 
HP =(3*( hfc +hf1) )+(4*( hfh +hf2) )+(24.44*( hfn +hf3))+(1.5*( hfo + hf4 )); 
hfp = -103.85; 
R =0.0837; 
hfo1 =0;
hf11 =0.054;
hfn1 =0; 
hfn22 =0.054; 
HR =(1*( hfp +(R*(tp -ta))) )+(6.5*( hfo1 + hf11 ) )+(24.44*(hfn1 + hfn22 )); 
Q=HP -HR; 
Q1 =(-Q/Mp); 

end Ex3_11;
