//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-03: Reactive Systems
//Example: 03.14 Page 
//======================================================

model Ex3_14
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real E (unit= "%")=100;
parameter Real T (unit= "K")=298;
parameter Real nc (unit= "moles")=1;
 

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real hfch (unit= "MJ/kmol")"Enthalphy of formation for propane";
Real HR (unit= "MJ/kmol")"Total enthalphy on the reactants side";
Real hfc (unit= "MJ/kmol")"Enthalphy of formation for CO2";
Real hfh (unit= "MJ/kmol")"Enthalphy of formation for water";
Real hfon (unit= "MJ/kmol")"Enthalphy of formation for oxygen and nitrogen";
Real x (unit= "MJ/kmol")"For adiabatic combustion enthalphy obtained for equating reactants and products";
Real hfn (unit= "MJ/kmol")"Trail to get the change in enthalphy of nitrogen";
Real T1 (unit= "K")"Assuming the products temp for first trail";
Real hfc1 (unit= "MJ/kmol")"Change in enthalphy for CO2 for trail temp";
Real hfh1 (unit= "MJ/kmol")"Change in enthalphy for water for trail temp";
Real hfo1 (unit= "MJ/kmol")"Change in enthalphy for oxygen for trail temp";
Real hfn1 (unit= "MJ/kmol")"Change in enthalphy for nitrogen for trail temp";
Real HP1 (unit= "MJ/kmol")"Total enthalphy of products for first trail";
Real T2 (unit= "K")"Assuming the products temp for second trail";
Real hfc2 (unit= "MJ/kmol")"Change in enthalphy for CO2 for trail temp";
Real hfh2 (unit= "MJ/kmol")"Change in enthalphy for water for trail temp";
Real hfo2 (unit= "MJ/kmol")"Change in enthalphy for oxygen for trail temp";
Real hfn2  (unit= "MJ/kmol")"Change in enthalphy for nitrogen for trail temp";
Real HP2  (unit= "MJ/kmol")"Total enthalphy of products for second trail";
Real Te (unit= "K")"Estimated adiabatic flame temp";


// Equation Section

equation
hfch = -103.85; 
HR=nc* hfch ; 
hfc = -393.52; 
hfh = -241.82;
hfon =0; 
x=HR -((3* hfc ) +(4* hfh ) +(5* hfon ) +(37.6* hfon ));
hfn =x /37.6; 
T1 =1500; 
hfc1 =61.714; 
hfh1 =48.095; 
hfo1 =40.61; 
hfn1 =38.405; 
HP1 =(HR -x) +(3* hfc1 ) +(4* hfh1 ) +(5* hfo1 ) +(37.6* hfn1 ); 
T2 =1600; 
hfc2 =67.58; 
hfh2 =52.844; 
hfo2 =44.279;
hfn2 =41.903; 
HP2 =(HR -x) +(3* hfc2 ) +(4* hfh2 ) +(5* hfo2 ) +(37.6* hfn2 ); 
Te =((( HR - HP1 )/( HP2 - HP1 ))*(T2 -T1))+ T1; 

end Ex3_14;
