//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-03: Reactive Systems
//Example: 03.18 Page 
//======================================================

model Ex3_18
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real T1 (unit= "K")=3000; 
parameter Real T2 (unit= "")=4000; 
parameter Real p (unit= "atm")=1; 
parameter Real KP1 (unit= "")=1.117; 
parameter Real KP2 (unit= "")=-1.593; 

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section

Real Kp1 (unit= "")"Value of equilibrium constant at 3000K";
Real Kp2 (unit= "")"Value of equilibrium constant at 4000K";
Real a1 (unit= "")"Dissociation of 1 mole of CO2 for the first trail";
Real a2 (unit= "")"Dissociation of 1 mole of CO2 for the second trail";
Real K1 (unit= "")"Value of equilibrium constant for first trail";
Real K2 (unit= "")"Value of equilibrium constant for second trail";
Real a12 (unit= "")"Approximate dissociation of 1 mole of CO2";
Real A12 (unit= "%")"Amount of CO2 will dissociate ";
Real a3 (unit= "")"Dissociation of 1 mole of CO2 for first trail";
Real a4 (unit= "")"Dissociation of 1 mole of CO2 for second trail";
Real K3 (unit= "")"Value of equilibrium constant for first trail";
Real K4 (unit= "")"Value of equilibrium constant for second trail";
Real a23 (unit= "")"Approximate dissociation of 1 mole of CO2";
Real A23 (unit= "%")"Amount of CO2 will dissociate";


// Equation Section

equation

Kp1 =e^KP1;
Kp2 =e^KP2;
a1 =0.4; 
a2 =0.5; 
K1 =3.674; 
K2 =2.236; 
a12 =((( K1 - Kp1 )/(K1 -K2) )*( a2 -a1))+ a1; 
A12 = a12 *100; 
a3 =0.9;
a4 =0.89;
K3 =0.1995; 
K4 =0.2227; 
a23 =((( Kp2 -K4)/(K3 -K4) )*( a3 -a4))+ a4; 
A23 = a23 *100; 

end Ex3_18;
