//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-03: Reactive Systems
//Example: 03.20 Page 
//======================================================

model Ex3_20
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real t (unit= "degC")=25; 
parameter Real p (unit= "atm")=1; 
parameter Real T1 (unit= "K")=2200; 
parameter Real T2 (unit= "K")=2400; 
parameter Real h1 (unit= "MJ/kmol")=59.86; 
parameter Real h2 (unit= "MJ/kmol")=66.915; 
parameter Real T (unit= "K")=298; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real HR (unit= "")"Total enthalphy on the reactants side since all the reactants are elements";
Real Kp1 (unit= "")"Natural logarithm of equilibrium constant at 2200K for the equation";
Real K1 (unit= "")"Value of equilibrium constant at 2200K";
Real a1 (unit= "")"By trail and error method the degree of dissociation of H2O";
Real hfh (unit= "MJ/kmol")"Enthalphy of formation of water at 2200 and 2400K";
Real hfh1 (unit= "MJ/kmol")"Change in enthalphy of water at 2200K";
Real hfd1 (unit= "MJ/kmol")"Change in enthalphy of hydrogen at 2200K";
Real hfo1 (unit= "MJ/kmol")"Change in enthalphy of oxygen at 2200K";
Real hfn1 (unit= "MJ/kmol")"Change in enthalphy of nitrogen at 2200K";
Real HP1 (unit= "MJ/kmol")"Enthalphy on the products side";
Real a2 (unit= "")"By trail and error method the degree of dissociation of H2O";
Real hfh2 (unit= "MJ/kmol")"Change in enthalphy of water at 2400K";
Real hfd2 (unit= "MJ/kmol")"Change in enthalphy of hydrogen at 2400K";
Real hfo2 (unit= "MJ/kmol")"Change in enthalphy of oxygen at 2400K";
Real hfn2 (unit= "MJ/kmol")"Change in enthalphy of nitrogen at 2400K";
Real HP2 (unit= "MJ/kmol")"Enthalphy on the products side";
Real H1 (unit= "MJ/kmol")"Total change in enthalphy at 2200K";
Real H2 (unit= "MJ/kmol")"Total change in enthalphy at 2400K";
Real Tl (unit= "K")"Required temp";

// Equation Section

equation
HR =0; 
Kp1 = -6.774; 
K1=e^Kp1;
a1 =0.02; 
hfh = -241.82; 
hfh1 =83.036;
hfd1 =59.86; 
hfo1 =66.802; 
hfn1 =63.371; 
HP1 =(0.98*( hfh + hfh1 )) +(0.02* hfd1 ) +(0.01* hfo1 ) +(1.88*hfn1 ); 
a2 =0.04; 
hfh2 =93.604; 
hfd2 =66.915; 
hfo2 =74.492; 
hfn2 =70.651; 
HP2 =(0.96*( hfh + hfh2 )) +(0.04* hfd2 ) +(0.02* hfo2 ) +(1.88*hfn2 );
H1=HP1 -HR; 
H2=HP2 -HR; 
Tl =((( T2 -T1 )/( HP2 - HP1 ))*( HR - HP1 ))+ T1; 

end Ex3_20;
