//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-4: Fuel Air Cycles and Their Analysis
//Example: 4.13 Page 
//======================================================

model Ex4_13
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real Tu (unit= "K")=645; 
parameter Real usu (unit= "kJ/kg")=310; 
parameter Real pu (unit= "bar")=15.6002; 
parameter Real Vu (unit= "m^3/kg")=0.124; 
parameter Real ee (unit= "")=1; 
parameter Real f (unit= "")=0.065; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real ufu (unit= "kJ/kg")"Internal energy of formation";
Real ub (unit= "kJ/kg")"Internal energy for constant volume adiabatic combustion";
Real Vb (unit= "m^3/kg")"Volume for constant volume adiabatic combustion";
Real Tb (unit= "K")"Temp for constant volume adiabatic combustion corrospodning to ub,Vb on burnt gas chart";
Real pb (unit= "kN/m^2")"Pressure for constant volume adiabatic combustion corrospodning to ub,Vb on burnt gas chart";
Real hfu (unit= "kJ/kg")"Enthalpht of formation";
Real hsu (unit= "kJ/kg")"Enthalphy from chart corrosponding to temp Tu";
Real hb (unit= "kJ/kg")"Enthaplhy for constant pressure adiabatic combustion";
Real pb1 (unit= "kN/m^2")"Pressure for constant pressure adiabatic combustion";
Real ub1 (unit= "kJ/kg")"Trail and error along the pb internal energy";
Real vb1 (unit= "m^3/kg")"Temp for constant pressure adiabatic combustion corrosponding to ub.Vb on burnt gas chart";
Real Tb1 (unit= "K")"";


// Equation Section

equation
ufu = -118.5 -(2963* f); 
ub=usu - ufu ; 
Vb=Vu; 
Tb =2820; 
pb =6500; 
hfu = -129.9 -(2958* f); 
hsu =440; 
hb=hsu+ hfu ; 
pb1 =1560; 
ub1 = -700; 
vb1 =(118 - ub1 )/pb; 
Tb1 =2420;

end Ex4_13;
