//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-4: Fuel Air Cycles and Their Analysis
//Example: 4.3 Page 
//======================================================

model Ex4_3
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real r (unit= "")=8; 
parameter Real af (unit= "")=15;
parameter Real p1 (unit= "bar")=1;
parameter Real t (unit= "deg C")=60;
parameter Real cv (unit= "kJ/kg")=44000;
parameter Real n (unit= "")=1.32;
parameter Real Cv (unit= "kJ/kgK")=0.717;

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real T1 (unit= "K")"Temp at begining of compression stroke";
Real p2 (unit= "bar")"Pressure at end of compression stroke";
Real T2 (unit= "K")"Temp at end of compression stroke";
Real f (unit= "kg")"Amount of fuel present in 1 kg of mixture";
Real a (unit= "kg")"Amount of air present in 1kg of mixture";
Real q23 (unit= "kJ/kg")"Heat trasnfer during process 2-3 per kg of mixture";
Real T3 (unit= "K")"Temp at point 3";
Real p3 (unit= "bar")"Pressure at point 3";
Real T31 (unit= "K")"Pressure at point 3";
Real p31 (unit= "bar")"Pressure at point 3";


// Equation Section

equation
T1=t +273; 
p2=p1 *(r)^n; 
T2=T1*r^(n -1) ; 
f =(1/( af +1) ); 
a=( af /( af +1) ); 
q23 =cv /( af +1) ; 
T3 =(( -10430+((10430) ^2+(4*494.8*10^5) )^(1/2) )/2); 
p3 =( T3/T1)*(r)*p1; 
T31 =( q23 /Cv)+T2; 
p31 =( T31 /T1)*r*p1; 

end Ex4_3;
