//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-4: Fuel Air Cycles and Their Analysis
//Example: 4.6 Page 
//======================================================

model Ex4_6
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real r (unit= "")=8; 
parameter Real lcv (unit= "kJ/kg")=44000;
parameter Real af (unit= "")=15;
parameter Real Cv (unit= "kJ/kgK")=0.71;
parameter Real p (unit= "bar")=1;
parameter Real t (unit= "deg C")=60;
parameter Real Mo (unit= "")=32;
parameter Real Mn (unit= "")=28.161;
parameter Real Mh (unit= "")=18;
parameter Real n (unit= "")=1.3;


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real T1 (unit= "K")"Temp at beginning of compression";
Real sa (unit= "")"Stiochiometric air fuel ratio";
Real Y (unit= "")"To balance oxygen and nitrogen";
Real x (unit= "")"By oxygen balance";
Real nb (unit= "%")"No. of moles before combustion";
Real na (unit= "%")"No. of moles after combustion";
Real Me (unit= "%")"% molecular expansion";
Real T2 (unit= "K")"Temp at point 2";
Real T3 (unit= "K")"Temp at point 3";
Real p3 (unit= "bar")"Pressure at point 3";
Real p31 (unit= "bar")"Pressure at point 3 with molecular expansion";

//Me=5.97 is correct answer

// Equation Section

equation
T1 =(t +273) ;
sa =(12.5*( Mo +(3.76* Mn) ))/((12*8) +(1* Mh));
Y=af *(((12*8) +(1* Mh))/( Mo +(3.76* Mn))); 
x =(12.5 - Y) *2; 
nb =1+Y+(Y *3.76) ; 
na=x +7.8+9+46.624; 
Me =((na -nb)/nb )*100;
T2=T1 *(r)^(n -1); 
T3 =( lcv /( af +1) )*(1/ Cv)+( T2); 
p3=r*( T3/T1)*p; 
p31 =p3 *( na/nb); 

end Ex4_6;
