//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-4: Fuel Air Cycles and Their Analysis
//Example: 4.8 Page 
//======================================================

model Ex4_8
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real T (unit= "K")=800; 
parameter Real ee (unit= "")=1; 

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real hi (unit= "MJ/kmol")"Sensible enthalphy for isooctane at 800K";
Real ho (unit= "MJ/kmol")"Sensible enthalphy for oxygen at 800K";
Real hn (unit= "MJ/kmol")"Sensible enthalphy for nitrogen at 800K";
Real nc (unit= "kmoles")"No. of kmoles of C8H18 for equivalence ratio for 1 kg of air";
Real no (unit= "kmoles")"No. of kmoles of oxygen for equivalence ratio for 1 kg of air";
Real nn (unit= "kmoles")"No. of kmoles of nitrogen for equivalence ratio for 1 kg of air";
Real Hs (unit= "MJ/kg air")"Total sensible enthalphy of reactants";
Real Hs1 (unit= "kJ/kg air")"Total sensible enthalphy of reactants";
Real R (unit= "kJ/khK")"Gas constant";
Real n (unit= "kmoles")"Total no. of kmoles for 1 kg of air";
Real Us (unit= "MJ/kg air")"Sensible internal energy of reactants ";
Real Us1 (unit= "kJ/kg air")"Sensible internal energy of reactants";


// Equation Section

equation
hi =154.723;
ho =15.841; 
hn =15.046; 
nc =0.00058; 
no =0.00725; 
nn =0.0273; 
Hs =( nc*hi)+( no*ho)+( nn*hn); 
Hs1 =Hs *1000; 
R =8.314; 
n=nc+no+nn; 
Us=Hs -((n*R *(T -298) )/1000); 
Us1 =Us *1000; 

end Ex4_8;
