//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-9: Carburettors and Fuel Injection in SI Engines
//Example: 9.2 Page 
//======================================================

model Ex9_2
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real Vs (unit= "m^3")=0.002; 
parameter Real nv (unit= "%")=75; 
parameter Real N (unit= "rpm")=4500; 
parameter Real p1 (unit= "bar")=1.013; 
parameter Real R (unit= "J/kgK")=287; 
parameter Real t1 (unit= "deg C")=15; 
parameter Real Cp (unit= "J/kgK")=1005; 
parameter Real g (unit= "")=1.4; 
parameter Real C2 (unit= "m/s")=100; 
parameter Real Cda (unit= "")=0.85; 
parameter Real Cdf (unit= "")=0.66; 
parameter Real sf (unit= "")=0.75; 
parameter Real d (unit= "")=0.4; 
parameter Real af (unit= "")=14; 
parameter Real Z (unit= "m")=0.006; 
parameter Real df (unit= "kg/m^3")=750; 



final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real Va (unit= "m^3/s")"Volume of air induced";
Real V1 (unit= "m^3/s")"Carburator delivers an air flow";
Real ma (unit= "kg/s")"Mass flow rate of air";
Real p2 (unit= "bar")"Pressure at throat";
Real da1 (unit= "kg/m^3")"Density of air";
Real da2 (unit= "kg/m^3")"Density of air at throat";
Real A2 (unit= "mm^2")"Throat area";
Real D (unit= "mm")"Choke diameter";
Real mf (unit= "kg/s")"Mass flow rate of fuel";
Real pm (unit= "N/mm^2")"Pressure difference across the main jet";
Real Aj (unit= "mm^2")"Area of jet";
Real dj (unit= "mm")"Diameter of jet";


// Equation Section

equation
Va =(( nv /100) *Vs*N) /(2*60) ; 
V1=Va /2; 
ma =( p1 *10^5* V1)/(R*( t1 +273) ); 
p2=p1 *(1 -( C2 ^2/(2* Cp *( t1 +273) )) )^( g/(g -1) ); 
da1 =(( p1 *10^5) /(R*( t1 +273) )); 
da2 = da1 *( p2/p1) ^(1/ g); 
A2 =( ma /( da2 *C2*Cda ) )*10^6; 
D =(( A2 *4) /( pi *0.84) )^(1/2) ; 
mf=ma/af; 
pm =(p1 -p2 -( g_n*Z*df /10^5) )*10^5; 
Aj =( mf /( Cdf *(2* df*pm) ^(1/2) )) *10^6; 
dj =(4* Aj/pi) ^(1/2) ; 

end Ex9_2;
