//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-9: Carburettors and Fuel Injection in SI Engines
//Example: 9.6 Page 
//======================================================

model Ex9_6
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real d2 (unit= "mm")=22; 
parameter Real Cda (unit= "")=0.82; 
parameter Real dj (unit= "mm")=1.2; 
parameter Real Cdf (unit= "")=0.7; 
parameter Real Z (unit= "m")=0.004; 
parameter Real da (unit= "kg/m^3")=1.2; 
parameter Real df (unit= "kg/m^3")=750; 
parameter Real P (unit= "bar")=0.075; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real A (unit= "")"Air fuel ratio";
Real A1 (unit= "")"Air fuel ratio when nozzle lip Z is oncisdered";
Real Ca2 (unit= "m/s")"Critical velocity at throat";

// Equation Section

equation
A=( Cda/ Cdf )*( d2 ^2/ dj ^2) *( da/df) ^(1/2) ; 
A1 =( Cda/ Cdf )*( d2 ^2/ dj ^2) *(( da*P)/( df *(P -(g_n*Z*df)/10^5) )) ^(1/2) ; 
Ca2 =(2* g_n*Z*df/da) ^(1/2) ; 

end Ex9_6;
