//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-9: Carburettors and Fuel Injection in SI Engines
//Example: 9.7 Page 
//======================================================

model Ex9_7
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real h (unit= "m")=4000; 
parameter Real A (unit= "")=14.7; 
parameter Real ts (unit= "deg C")=22; 
parameter Real R (unit= "J/kgK")=287; 

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real ta (unit= "deg C")"Temp at altitude";
Real p (unit= "bar")"Pressure at altitude";
Real da (unit= "kg/m^3")"Density at altitude";
Real ds (unit= "kg/m^3")"Density at sea level";
Real Aa (unit= "")"Air fuel ratio at altitude";


// Equation Section

equation
ta=ts -(0.0065* h); 
p =1.013/10^0.2083; 
da =(p *10^5) /(R*( ta +273) ); 
ds =(1.013*10^5) /(R*( ts +273) ); 
Aa=A*( da/ds) ^(1/2) ; 

end Ex9_7;
