//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-10: CI Engines Fuel Injection System
//Example: 10.3 Page 
//======================================================

model Ex10_3
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real d (unit= "m")=0.8e-3; 
parameter Real A (unit= "m^2")=1.65e-6;
parameter Real Cd (unit= "")=0.9;
parameter Real Cp (unit= "")=0.85;
parameter Real p1 (unit= "bar")=170;
parameter Real p2 (unit= "bar")=25;
parameter Real df (unit= "kg/m^3")=850;


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real Q (unit= "cm^3/s")"Adding two equations and solving then the discharge";
Real p (unit= "bar")"Pressure immediately formed before orifice";
Real Cf (unit= "m/s")"Velocity of fuel flow through orifice";


// Equation Section

equation
Q =((145/(22.931*10^9) ) ^(1/2) )*10^6; 
p =170 -(2.161*10^9*( Q /10^6) ^2); 
Cf=Cd *((2*(p-p2) *10^5) /df) ^(1/2) ;

end Ex10_3;
