//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-11: Two Stroke Engines
//Example: 11.3 Page 
//======================================================

model Ex11_3
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real mf (unit= "kg/h")=6.5; 
parameter Real N (unit= "rpm")=3000; 
parameter Real a (unit= "")=15; 
parameter Real CV (unit= "kJ/kg")=44000; 
parameter Real pm (unit= "m/s")=9; 
parameter Real pmi (unit= "bar")=4.8; 
parameter Real nsc (unit= "%")=85; 
parameter Real nm (unit= "%")=80; 
parameter Real R (unit= "J/kgK")=290; 
parameter Real p (unit= "bar")=1.03; 
parameter Real T (unit= "K")=288; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real ma (unit= "kg/h")"Mass flow rate of air";
Real L (unit= "cm")"Length of stroke";
Real mac (unit= "kg/h")"Actual mass flow rate";
Real mi (unit= "kg/h")"Ideal mass flow rate";
Real da (unit= "kg/m^3")"Densty of mixture";
Real d (unit= "cm")"Diameter of bore";
Real ip (unit= "kW")"Power obtained";
Real bp (unit= "kW")"Brake power";
Real nth (unit= "%")"Thermal efficiency of engine";


// Equation Section

equation
ma=a*mf; //
L =(( pm *60) /(2* N) )*100; 
mac =mf+ma; 
mi =( mac)/( nsc /100) ; 
da =(p *10^5) /(R*T); 
d =((( mi/da) *(4/ pi) *(1/( L /100) ) *(1/(60* N)) )^(1/2))*100;
ip =( pmi *10^5*( L /100) *(( pi /4) *(d /100) ^2) *N) /(60*1000); 
bp=ip *( nm /100) ;
nth =( bp /(( mf /3600) *CV)) *100; 

end Ex11_3;

