//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-11: Two Stroke Engines
//Example: 11.5 Page 
//======================================================

model Ex11_5
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real d (unit= "cm")=8.25; 
parameter Real L (unit= "cm")=11.25; 
parameter Real r (unit= "")=8; 
parameter Real N (unit= "rpm")=2500; 
parameter Real ip (unit= "kW")=17; 
parameter Real a (unit= "")=0.08; 
parameter Real T (unit= "K")=345; 
parameter Real p (unit= "bar")=1.02; 
parameter Real CV (unit= "kL/kg")=44000; 
parameter Real nth (unit= "")=0.29; 
parameter Real M (unit= "")=114; 
parameter Real R (unit= "J/kgK")=8314; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real Vs (unit= "cm^3")"Displacement volume";
Real V (unit= "m^3")"Total cylinder volume";
Real ps (unit= "kg/m^3")"Density of dry air";
Real nsc (unit= "%")"Scavenging efficiency";


// Equation Section

equation
Vs =( pi*d ^2* L)/4; 
V=(r/(r -1) )*Vs; 
ps =((29* p *10^5) /(R*T) )*(1/(1+ a *(29/ M))); 
nsc =(( ip *1000) /(( N /60) *V *1e-6* ps*a*CV *1000* nth ))*100; 

end Ex11_5;

