//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-15: Air Capacity and Supercharging
//Example: 15.4 Page 
//======================================================

model Ex15_4
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real d (unit= "m")=0.1; 
parameter Real L (unit= "m")=0.12; 
parameter Real N (unit= "rpm")=3000; 
parameter Real n (unit= "")=4; 
parameter Real R (unit= "J/kgK")=287; 
parameter Real t (unit= "Nm")=120; 
parameter Real nm (unit= "%")=85; 
parameter Real T1 (unit= "K")=288; 
parameter Real p1 (unit= "bar")=1; 
parameter Real Q (unit= "kJ/min")=1200; 
parameter Real T (unit= "K")=328; 
parameter Real p (unit= "")=1.7; 
parameter Real nv (unit= "")=90; 
parameter Real Cp (unit= "")=1.005; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real bp (unit= "kW")"";
Real ip (unit= "kW")"";
Real pmi (unit= "bar")"";
Real Vs (unit= "m^3")"";
Real Vs1 (unit= "m^3/min")"";
Real V1 (unit= "m^3/min")"";
Real me (unit= "kg/h")"";
Real E (unit= "kJ/s")"";
Real T2 (unit= "K")"";
Real mc (unit= "kg/h")"";
Real maf (unit= "kg/h")"";


// Equation Section

equation
bp =(2* pi*N*t) /(60*1000) ; 
ip=bp /( nm /100) ; 
pmi =(( ip *2*60*1000*4) /(L*( pi*d^2)*N*n ))/10^5; 
Vs =( pi /4) *d ^2* L; 
Vs1 =Vs *(N/2)*n; 
V1 =( nv /100) *Vs1; 
me =((p *10^5* V1)/(R*T) )*60; 
E=Q /60; 
T2 =(( bp/E)*T-T1 )/(( bp/E) -1);
mc =(( bp)/( Cp *(T2 -T1)) )*3600; 
maf =mc -me; 

end Ex15_4;
