//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-15: Air Capacity and Supercharging
//Example: 15.5 Page 
//======================================================

model Ex15_5
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real Vs (unit= "m^3")=0.0045; 
parameter Real N (unit= "rpm")=4000;
parameter Real nv (unit= "%")=150;
parameter Real ni (unit= "%")=90;
parameter Real nm (unit= "%")=85;
parameter Real T (unit= "K")=330;
parameter Real p2 (unit= "bar")=1.8;
parameter Real T1 (unit= "K")=290;
parameter Real p1 (unit= "bar")=1;
parameter Real R (unit= "J/kgK")=287;
parameter Real g (unit= "")=1.4;
parameter Real Cp (unit= "kJ/kgK")=1.005;


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real T21 (unit= "K")"Temp at 2";
Real T2 (unit= "K")"Temp of air after compressor";
Real Vs1 (unit= "m^3/s")"Rate of swept volume";
Real Va (unit= "m^3/s")"Volume of air induced";
Real d (unit= "kg/m^3")"Density of air at ambinet condition";
Real ma (unit= "kg/s")"Mass of air induced";
Real Q (unit= "kJ/s")"Heat rejected from after cooler";
Real P (unit= "kW")"Power needed to run the compressor";
Real Pa (unit= "kW")"Power absorbed from engine";


// Equation Section

equation
T21 =T1 *( p2/p1) ^((g -1)/g);
T2=T1 +(( T21 -T1)/( ni /100) ); 
Vs1 =Vs *(N /(2*60) ); 
Va =( nv /100) *Vs1;
d=( p1 *10^5) /(R*T1); 
ma=d*Va; 
Q=ma*Cp *(T2 -T);
P=ma*Cp *(T2 -T1); 
Pa=P/( nm /100) ; 

end Ex15_5;
