//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-15: Air Capacity and Supercharging
//Example: 15.6 Page 
//======================================================

model Ex15_6
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real p1 (unit= "bar")=0.98;
parameter Real T1 (unit= "K")=290;
parameter Real p2 (unit= "bar")=1.8;
parameter Real a (unit= "")=20;
parameter Real T3 (unit= "K")=850;
parameter Real p3 (unit= "bar")=1.6;
parameter Real p4 (unit= "bar")=1.03;
parameter Real nc (unit= "%")=80;
parameter Real nt (unit= "%")=85;
parameter Real Cpa (unit= "kJ/kgK")=1.005;
parameter Real Cpg (unit= "kJ/kgK")=1.15;
parameter Real g (unit= "")=1.33;
parameter Real h (unit= "")=1.4;
 

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real T21 (unit= "K")"Temp at point 2 for compressor";
Real T2 (unit= "K")"Temp of air leaving compressor";
Real T22 (unit= "deg C")"Temp of air leaving compressor";
Real T41 (unit= "K")"Temp at point 4 for turbine";
Real T4 (unit= "K")"Temp of gas leaving turbine";
Real T44 (unit= "deg C")"Temp of gas leaving turbine";
Real mf (unit= "kg/s")"Assume mass flow rate of fuel";
Real ma (unit= "kg/s")"Mass flow rate of air";
Real Wc (unit= "kW")"Power required by compressor";
Real mg (unit= "kg/s")"Mass flow rate of gas";
Real Wt (unit= "kW")"Power developed by turbine";
Real Pt (unit= "%")"% of turbine poer used to run compressor";


// Equation Section

equation
T21 =T1 *( p2/p1) ^((h -1)/h); 
T2=T1 +(( T21 -T1)/( nc /100) ); 
T22 =T2 -273; 
T41 =T3 *( p4/p3) ^((g -1)/g); 
T4=T3 -(( nt /100) *(T3 - T41 )); 
T44 =T4 -273; 
mf =1; 
ma=mf*a; 
Wc=ma* Cpa *(T2 -T1); 
mg=ma+mf; 
Wt=mg* Cpg *(T3 -T4); 
Pt =( Wc/Wt) *100; 

end Ex15_6;
