//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-15: Air Capacity and Supercharging
//Example: 15.7 Page 
//======================================================

model Ex15_7
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real a (unit= "")=14; 
parameter Real T1 (unit= "K")=288; 
parameter Real T2 (unit= "K")=265; 
parameter Real p (unit= "")=1.3; 
parameter Real nc (unit= "%")=75; 
parameter Real Cpm (unit= "kJ/kgK")=1.05; 
parameter Real Cpa (unit= "kJ/kgK")=1.005; 
parameter Real g (unit= "")=1.33; 
parameter Real h (unit= "")=1.4; 
parameter Real ma (unit= "kg/s")=1; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real T31 (unit= "K")"Temp at point 3";
Real T3 (unit= "K")"Temp of gas after compressor";
Real mm (unit= "kg/s")"Mass flow rate of mixture";
Real Wc1 (unit= "kW/kg")"Power required by compressor";
Real T21 (unit= "K")"Temp at point 2";
Real T4 (unit= "K")"Temp after leaving compressor";
Real Wc2 (unit= "kW/kg of air per second")"Power required by compressor";
Real T5 (unit= "K")"Temp of gas after carburettor";
Real Ps (unit= "%")"Saving of power in first case";

//Round off error in book answer

// Equation Section

equation
T31 =T2*p^((g -1) /g); 
T3=T2 +(( T31 -T2)/( nc /100) ); 
mm =1+(1/ a); 
Wc1 =mm*Cpm *(T3 -T2); 
T21 =T1*p^((h -1) /h); 
T4=T1 +(( T21 -T1)/( nc /100) ); 
Wc2 =ma*Cpa *(T4 -T1); 
T5=T4 -23; 
Ps =(( Wc2 - Wc1 ) *100)/ (Wc2) ;

end Ex15_7;
