//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-16: Engine Testing and Performance
//Example: 16.10 Page 
//======================================================

model Ex16_10
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real d (unit= "m")=0.18; 
parameter Real L (unit= "m")=0.24; 
parameter Real t (unit= "min")=30; 
parameter Real N (unit= "rev")=9000; 
parameter Real Ne (unit= "No. of explosions")=4450; 
parameter Real pmi (unit= "bar")=5.35; 
parameter Real pp (unit= "bar")=0.35; 
parameter Real W (unit= "kg")=40; 
parameter Real dd (unit= "m")=0.96; 
parameter Real dr (unit= "m")=0.04; 
parameter Real V (unit= "m^3")=2.6; 
parameter Real pg (unit= "mm of Hg")=136; 
parameter Real dg (unit= "kg/m^3")=0.655; 
parameter Real T (unit= "K")=290; 
parameter Real CV (unit= "kJ/m^3")=19000; 
parameter Real ta (unit= "m^3")=40; 
parameter Real p (unit= "mm of Hg")=720; 
parameter Real Te (unit= "deg C")=340; 
parameter Real Cpg (unit= "kJ/kgK")=1.1; 
parameter Real C (unit= "kg")=80; 
parameter Real Tr (unit= "deg C")=30; 
parameter Real R (unit= "J/kgK")=287;


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real ip (unit= "kW")"Indicated power";
Real bp (unit= "kW")"Brake power";
Real pgs (unit= "mm of Hg")"Pressure of gas supplied";
Real Vg (unit= "m^3")"Volume of gas ";
Real Q (unit= "kJ/min")"Heat supplied by gas used at NTP";
Real Qbp (unit= "kJ/min")"Heat equivalent of bp";
Real Qc (unit= "kJ/min")"Heat lost to cooling medium";
Real Va (unit= "kg/min")"Volume of air used";
Real da (unit= "kg/m^3")"Density of air";
Real ma (unit= "kg/min")"Mass of air used";
Real mg (unit= "kg/min")"Mass of gas at NTP";
Real me (unit= "kg/min")"Total mass of exhaust gas";
Real Qe (unit= "kJ/min")"Heat loss to exhaust gas";
Real Qu (unit= "kJ/min")"Unaccounted heat loss";
Real nm (unit= "%")"Mechanical efficiency";
Real ni (unit= "%")"Indicated thermal efficiency";
Real x (unit= "bp")"% heat";
Real y (unit= "%")"% heat lost to cooling water";
Real z (unit= "%")"% heat to exhaust gases";
Real k (unit= "%")"% heat unaccounted";


// Equation Section

equation
ip =( pmi -pp) *10^5* L*( pi /4)*d ^2*( Ne /(30*60) ) *(1/1000) ;
bp =( pi *(N /(30*60) )*W *9.81*( dd+dr) *(1/1000) ); 
pgs =760+( pg /13.6) ; 
Vg =(( pgs *V) /290) *(273/760) ; 
Q=( Vg*CV) /30;
Qbp =bp *60; 
Qc =(C/t) *4.18* Tr; 
Va =((( p*ta)/T) *(273/760) )/30; 
da =(1.013*10^5) /(R *273) ; 
ma=Va*da; 
mg =( Vg /30) *dg; 
me=ma+mg; 
Qe=me* Cpg *(Te -(T -273) ); 
Qu=Q -( Qe+Qc+Qbp); 
nm =( bp/ip) *100;
ni =(( ip *60) /Q) *100; 
x =(( Qbp /1571) *100) ; 
y =(( Qc /1571) *100) ;
z =(( Qe /1571) *100) ; 
k =(( Qu /1571) *100) ; 

end Ex16_10;
