//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-16: Engine Testing and Performance
//Example: 16.12 Page 
//======================================================

model Ex16_12
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real n (unit= "")=4; 
parameter Real d (unit= "m")=0.085;
parameter Real L (unit= "m")=0.095;
parameter Real tr (unit= "m")=0.35;
parameter Real N (unit= "rpm")=3000;
parameter Real w (unit= "N")=430;
parameter Real w1 (unit= "N")=300;
parameter Real mf (unit= "kg/min")=0.24;
parameter Real CV (unit= "kJ/kg")=44000;
parameter Real mw (unit= "kg/min")=65;
parameter Real Tw (unit= "deg C")=12;
parameter Real a (unit= "")=15;
parameter Real Te (unit= "deg C")=450;
parameter Real Ta (unit= "deg C")=17;
parameter Real p (unit= "cm of Hg")=76;
parameter Real H (unit= "%")=15.5;
parameter Real Cpe (unit= "kJ/kgK")=1;
parameter Real Cps (unit= "kJ/kgK")=2;
parameter Real Cpw (unit= "kJ/kgK")=4.18;
parameter Real Ts (unit= "deg C")=100;
parameter Real hfg (unit= "kJ/kg")=2257;
parameter Real R (unit= "J/kgK")=287;



final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real bp (unit= "kW")"Brake power";
Real bp1 (unit= "kW")"Brake power when each cylinder is cut off";
Real ip (unit= "kW")"Indicated power per cycle";
Real ip1 (unit= "kW")"INdicated of engine";
Real imep (unit= "bar")"Indicated mean effective pressure";
Real ni (unit= "%")"Indicated thermal efficiency";
Real bsfc (unit= "kg/kWh")"Brake specific fuel consumption";
Real Vs (unit= "m^3/min")"Sept volume";
Real ma (unit= "kg/min")"Mass flow rate of air";
Real da (unit= "kg/m^3")"Density of air";
Real Va (unit= "m^3/min")"Volume of air flow";
Real nv (unit= "%")"Volumetric efficiency";
Real Qf (unit= "kJ/min")"Heat supplied by fuel";
Real Qbp (unit= "kJ/min")"Heat equivalent to bp";
Real Qc (unit= "kJ/min")"Heat lost to cooling water";
Real mv (unit= "kg/min")"Mass of water vapour";
Real me (unit= "kg/min")"Mass of dry exhaust gas";
Real Qe (unit= "kJ/min")"Heat carried away by exhaust gas";
Real Qs (unit= "kJ/min")"Heat lost in steam";
Real Qu (unit= "kJ/min")"Unaccounted heat loss";
Real l (unit= "%")"% of unaccounted heat lost";
Real x (unit= "bp")"% of heat";
Real y (unit= "%")"% of heat loss in cooling water";
Real z (unit= "%")"% heat loss in dry exhaust gas";
Real k (unit= "%")"% heat lost to steam";



// Equation Section

equation
bp =(2* pi*N*w*tr) /(60*1000) ; 
bp1 =(2* pi*N*w1 *0.35) /(60*1000) ; 
ip=bp - bp1 ; 
ip1 =n*ip; 
imep =(( ip1 *60*1000) /(L*( pi /4)*d ^2*( N/2)*n) )/10^5; 
ni =(( ip1 *60) /( mf*CV) )*100; 
bsfc =( mf *60) /bp; 
Vs =( pi /4) *d ^2* L*(N /2) *n; 
ma=a*mf; 
da =(1*10^5) /(R*( Ta +273) ); 
Va=ma/da; 
nv =( Va/Vs )*100; 
Qf=mf*CV; 
Qbp =bp *60; 
Qc=mw* Cpw *Tw; 
mv =9*( H /100) *mf; 
me=ma+mf -mv; 
Qe=me* Cpe *(Te -Ta); 
Qs =( mv *(( Cpw *(Ts -Ta))+ hfg +( Cps *(Te -Ts)))); 
Qu=Qf -( Qbp +Qc+Qe+Qs); 
x=( Qbp/Qf) *100; 
y=( Qc/Qf) *100; 
z=( Qe/Qf) *100; 
k=( Qs/Qf) *100; 
l=( Qu/Qf) *100;

end Ex16_12;
