//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-16: Engine Testing and Performance
//Example: 16.2 Page 
//======================================================

model Ex16_2
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real d (unit= "m")=0.175; 
parameter Real L (unit= "m")=0.32;
parameter Real p (unit= "bar")=6.5;
parameter Real pp (unit= "bar")=0.4;
parameter Real N (unit= "rpm")=510;
parameter Real pm (unit= "bar")=0.65;
parameter Real n (unit= "Firing strokes per minute")=55;


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real pmi (unit= "bar")"Net imep at full load";
Real c (unit= "cycles per min")"Dead cycles per minute at no load";
Real ipw (unit= "kW")"Indicating power for working cycles";
Real Pp (unit= "kW")"Pumping power of dead cycles";
Real fp (unit= "kW")"Power";
Real fip (unit= "kW")"Full load indicated power";
Real fbp (unit= "kW")"Full load break power";
Real nm (unit= "%")"Mechanical efficiancy";


// Equation Section

equation
pmi =p-pp; 
c =(( N/2) -n); 
ipw = pmi *10^5* L*( pi /4)*d ^2*( n /60) *(1/1000) ; 
Pp=pm *10^5* L*( pi /4) *d ^2*( c /60) *(1/1000) ;
fp=ipw -Pp; 
fip = pmi *10^5* L*( pi /4)*d ^2*( N /(2*60) ) *(1/1000) ; 
fbp =fip -fp; 
nm =( fbp/ fip ) *100; 

end Ex16_2;
