//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-16: Engine Testing and Performance
//Example: 16.3 Page 
//======================================================

model Ex16_3
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real d (unit= "m")=0.09;//Diameter of bore 
parameter Real L (unit= "m")=0.1; //Length of stroke
parameter Real T (unit= "Nm")=120; //Torque measured
parameter Real n (unit= "")=4; //No. of cylinders


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real pmb (unit= "bar")"Brake mean effective pressure";

// Equation Section

equation
pmb =((4* pi*T)/(L*( pi /4) *d ^2* n) )/10^5; 

end Ex16_3;
