//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-16: Engine Testing and Performance
//Example: 16.4 Page 
//======================================================

model Ex16_4
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real d (unit= "m")=0.06; 
parameter Real L (unit= "m")=0.085;
parameter Real N (unit= "rpm")=3000;
parameter Real r (unit= "m")=0.35;
parameter Real W (unit= "N")=160;
parameter Real f (unit= "1/h")=6.6;
parameter Real g (unit= "")=0.78;
parameter Real CV (unit= "kJ/kg")=44000;
parameter Real w1 (unit= "N")=114;
parameter Real w2 (unit= "N")=110;
parameter Real w3 (unit= "N")=112;
parameter Real w4 (unit= "N")=116;
parameter Real n (unit= "")=4;


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real Vf (unit= "m^3/s")"Volume flow rate of fuel";
Real df (unit= "kg/m^3")"Density of fuel";
Real mf (unit= "kg/s")"Mass flow rate of fuel";
Real T (unit= "Nm")"Torque";
Real bp (unit= "kW")"Brake power";
Real pmb (unit= "bar")"Break mean effective pressure";
Real nb (unit= "%")"Brake thermal efficiency";
Real bsfc (unit= "kg/kWh")"Brake specific fuel consumption";
Real bp1 (unit= "kW")"Brake power from morse test";
Real ip1 (unit= "kW")"Indicated power";
Real ip2 (unit= "kW")"Indicated power";
Real ip3 (unit= "kW")"Indicated power";
Real ip4 (unit= "kW")"Indicated power";
Real ip (unit= "kW")"Total indicated power";
Real nm (unit= "%")"Mechanical efficiency";
Real pmi (unit= "bar")"imep";



// Equation Section

equation
Vf =(f *10e-4) /3600; 
df=g *1000; 
mf=df*Vf; 
T=W*r; 
bp =(2* pi*N*T) /(60*1000) ; 
pmb =((120* bp *1000) /(L*( pi /4) *d ^2* N*n) )/10^5; 
nb =( bp/( mf*CV) )*100; 
bsfc =( mf *3600) /bp; 
bp1 =((2* pi*N*w1*r) /(60*1000) ); 
ip1 =bp -bp1;
ip2 =bp -((2* pi*N*w2*r) /(60*1000) ); 
ip3 =bp -((2* pi*N*w3*r) /(60*1000) ); 
ip4 =bp -((2* pi*N*w4*r) /(60*1000) ); 
ip=ip1+ ip2 + ip3 +ip4 ; 
nm =( bp/ip) *100; 
pmi = pmb /( nm /100) ; 

end Ex16_4;
