//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-16: Engine Testing and Performance
//Example: 16.7 Page 
//======================================================

model Ex16_7
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real n (unit= "")=6;
parameter Real Do (unit= "m")=0.03; 
parameter Real Cd (unit= "")=0.6; 
parameter Real H (unit= "")=0.14; 
parameter Real d (unit= "m")=0.1; 
parameter Real L (unit= "m")=0.11; 
parameter Real W (unit= "N")=540; 
parameter Real N (unit= "rpm")=2500; 
parameter Real ch (unit= "")=4.8823;
parameter Real p (unit= "bar")=1; 
parameter Real t (unit= "s")=18; 
parameter Real f (unit= "cc")=100; 
parameter Real T (unit= "K")=300; 
parameter Real df (unit= "kg/m^3")=780; 
parameter Real R (unit= "J/kgK")=287; 
parameter Real dhg (unit= "kg/m^3")=13600; 
 

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real da (unit= "kg/m^3")"Density of air";
Real Va (unit= "m^3/s")"Volume flow rate of air";
Real Vs (unit= "m^3/s")"Swept volume per second";
Real nv (unit= "%")"Volumetric efficiency";
Real bp (unit= "kW")"Brake power";
Real bmep (unit= "bar")"Brake mean effective power";
Real Tor (unit= "Nm")"Torque";
Real mf (unit= "kg/h")"Mass flow rate of fuel";
Real bsfc (unit= "kg/kWh")"Brake specific fuel consumption";
Real so (unit= "kg/kg fuel")"Stoichiometric oxygen required per kg of fuel";
Real sa (unit= "kg/kg fuel")"Stoichiometric air required per kg of fuel";
Real maa (unit= "kg/s")"Actual mass flow rate of air";
Real af (unit= "")"Actual air fuel ratio";
Real pea (unit= "%")"Percentage of excess air";


// Equation Section

equation
da =(p *10^5) /(R*T); //
Va =( Cd *( pi /4) *Do ^2*(2* g_n*H*( dhg /da) )^(1/2) ); 
Vs =( pi /4) *d ^2* L*(N /(2*60) )*n; 
nv =( Va/Vs) *100;
bp =(W*N) /(20000) ; 
bmep =(( bp *1000) /(L*( pi /4) *d ^2*( N /(2*60) )*n) )/10^5; 
Tor =(60* bp *1000) /(2* pi*N);
mf =(f /18) *(780/1000) *(1/1000) *3600; 
bsfc =mf/bp; 
so =(0.83*(32/12) ) +(0.17*(8/1) ); 
sa=so/ bsfc ; 
maa =Va*da; 
af =( maa *3600) /mf;
pea =(( af -sa)/sa )*100; 

end Ex16_7;
