//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-02: Air Standard Cycles and their Analysis
//Example: 02.1 Page 
//======================================================

model Ex2_1
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real d (unit= "cm")=20;//"Cylinder bore diameter"
parameter Real L (unit= "cm")=25; //"Stroke length"
parameter Real Vc (unit= "cm^3")=1570; //"The clearance volume"
parameter Real P1 (unit= "bar")=1; //"Pressure at the beginning of compression"
parameter Real T1 (unit= "K")=300; //"Temperature at the beginning of compression"
parameter Real T3 (unit= "K")=1673; //"Maximum temperature of cycle"
parameter Real Cv (unit= "kJ/kgK")=0.718; //"Specific heat at constant volume of air"
parameter Real R (unit= "kJ/kgK")=0.287; //"Real gas constant"
parameter Real g (unit= "")=1.4; //"Isentropic index"
parameter Real c (unit= "")=500; //"Number of cycles per minute"

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real Vs (unit= "cm^3")"Swept volume";
Real V1 (unit= "cm^3")"According to PV diagram Total volume";
Real V2 (unit= "cm^3")"Volume according to PV diagram";
Real r (unit= "")"Compression ratio";
Real T2 (unit= "K")"In isentropic process, Temperature at point 2";
Real P2 (unit= "bar")"In isentropic process, Pressure at point 2";
Real P3 (unit= "bar")"In constant volume process, Pressure at point 2";
Real T4 (unit= "K")"In isentropic process, Temperature at point 4";
Real P4 (unit= "bar")"In isentropic process, Pressure at point 4";
Real no (unit= "")"Air standard efficiency of Otto cycle";
Real Q1 (unit= "kJ/kg")"Heat supplied";
Real Q2 (unit= "kJ/kg")"Heat rejected";
Real W (unit= "kj/kg")"Work done per unit mass";
Real m (unit= "kg")"Amount of mass";
Real W1 (unit= "kJ")"Work done";
Real pm (unit= "bar")"Mean effective pressure";
Real P (unit= "kW")"Power developed";


// Equation Section

equation
Vs =( pi /4) *d ^2*L; 
V1= Vs+ Vc;
V2=Vc; 
r=V1/V2; 
T2=T1*r^(g -1) ; 
P2=P1*r^g; 
P3=P2 *( T3/T2); 
T4=T3 *(1/ r)^(g -1); 
P4=P3 *(1/ r)^(g); 
no =(1 -(1/ r)^(g -1)) *100; 
Q1=Cv *(T3 -T2); 
Q2=Cv *(T4 -T1); 
W=Q1 -Q2; 
m =((P1*V1)/(10000*R*T1)); 
W1=W*m; 
pm =( W1 *10^9) /(10^5*Vs) ; 
P=W1 *(c /60) ; 

end Ex2_1;
