//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-02: Air Standard Cycles and their Analysis
//Example: 02.5 Page 
//======================================================

model Ex2_5
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real Pm (unit= "bar")=7; //Mean effective pressure
parameter Real p1 (unit= "bar")=1; //Initial pressure
parameter Real r (unit= "")=12; //Compression ratio
parameter Real g (unit= "")=1.4; //Isentropic index

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real B (unit= "")"Cut off ratio";
Real n (unit= "")"Air standard efficiency";

//Book answer is wrong

// Equation Section

equation
Pm=p1*(g*r^g*(B-1)-r*(B^g-1))/((g-1)*(r-1));
n=(1)-(((B^g)-1)/(r^(g-1)*g*(B-1)));

end Ex2_5;
